package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice7709Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice7709Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 7709-壹企付用户签约成功后台通知
 * <pre>
 *   7703-壹企付用户签约入网交易支付平台受理成功后会进行处理，
 *   签约成功后支付平台会给机构系统发送结果通知，
 *   支付平台将后台通知发送到机构在上线申请表中提供的后台通知地址。
 *   机构系统收到该通知后需要给支付平台返回固定的响应，
 *   如果支付平台在5秒内未收到机构系统返回的通知响应或者接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，
 *   这时支付平台会向机构系统补发通知，最多补发两次，共发三次。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice7709Strategy implements NoticeStrategy<Notice7709Request> {
  @Autowired(required = false)
  private List<Notice7709Listener> notice7709Listeners;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_7709.getCode();
  }

  @Override
  public Notice7709Request exchange(NoticeRequest request) throws Exception {
    return new Notice7709Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice7709Request notice7709Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice7709Listeners)) {
        for (Notice7709Listener listener : notice7709Listeners) {
          listener.onNotice(notice7709Request);
        }
      }
    } catch (Exception e) {
      log.error("壹企付用户签约成功后台通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
