package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.cancleAccount.Tx5086Request;
import com.biz.crm.cpcnpay.core.tx.cancleAccount.Tx5086Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 5086-冻结订单分账撤销查询
 * @author Keller
 */
@Component
@Slf4j
public class Tx5086Strategy extends AbstractTxStrategy<Tx5086Request, Tx5086Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5086_REQUEST.getCode();
  }

  @Override
  public Class<Tx5086Response> getResponse() {
    return Tx5086Response.class;
  }
}
