package com.biz.crm.cpcnpay.core.tx.aggregate;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 5016-支付查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx5016Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 统一订单号
   */
  private String orderNo;
  /**
   * 支付流水号
   */
  private String txSN;
  /**
   * 支付金额，单位:分
   */
  private String amount;
  /**
   * 可用分账金额，单位:分
   */
  private String availableSplitAmount;
  /**
   * 支付状态:
   *
   * 10=未支付
   * 20=支付处理中
   * 30=支付成功
   * 40=支付失败
   * 50=订单关闭
   */
  private String status;
  /**
   * 支付方式:
   *
   * 00=余额支付
   * 02=信用支付
   * 10=快捷支付
   * 11=信用卡分期(快捷)
   * 20=网银支付
   * 30=代收支付
   * 40=聚合支付 (停止接入新 商户)
   * 42=条码支付
   * 50=O2O
   * 60=POS (暂不支持)
   * 80=跳转支付
   * 81=信用卡分期(银联 H5)
   * 90=外卡收单
   */
  private String paymentWay;
  /**
   * 收款用户手续费总金额, 单位:分
   */
  private String payeeUserFee;
  /**
   * 付款人手续费总金额, 单位:分
   */
  private String payerUserFee;
  /**
   * 聚合支付类型:
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   * 40=聚合码
   */
  private String qRPaymentType;
  /**
   * 聚合支付方式:
   *
   * 41=正扫
   * 42=反扫
   * 43=公众号 (服务窗)
   * 44=小程序
   * 45=H5
   * 46=APP
   *
   * PaymentWay=40 和 42 时非空
   */
  private String qRPaymentWay;
  /**
   * 实际支付方式
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   */
  private String actualPayType;
  /**
   * 申码系统流水号
   *
   * PaymentWay=42,ScanPaymentType=40 时非空
   */
  private String applyCodeNO;
  /**
   * 付款银行
   */
  private String bankID;
  /**
   * 付款账户名称
   */
  private String payerAccountName;
  /**
   * 付款账户号码
   */
  private String payerAccountNumber;
  /**
   * 分支行
   */
  private String payerBranchName;
  /**
   * 省
   */
  private String payerProvince;
  /**
   * 城市
   */
  private String payerCity;
  /**
   * 支付回单流水号
   */
  private String bankTraceNo;
  /**
   * 平台订单号
   */
  @Deprecated
  private String traceNo;
  /**
   * 分期银行
   */
  private String installmentBankID;
  /**
   * 分期期数
   */
  private String installmentPeriods;
  /**
   * 失效时间
   *
   * 格式: yyyyMMddHHmmssSSS， 默认为30 天(30*24*60分钟)
   */
  private String expireTime;
  /**
   * 付款用户 ID
   *
   * PaymentWay=40、42和 80 时返回,ActualPayType=10 时,为微信的openid;ActualPayType=20 时,为支 付宝的 Buyer_user_id
   */
  private String payerID;
  /**
   * 支付类型:21-2B2C,22-B2B
   */
  private String orderType;
  /**
   * 收款人名称
   */
  private String payeeName;
  /**
   * 收款人账号
   */
  private String payeeAccountNumber;
  /**
   * 实际支付方式为微信， 支付时为微信的子商户 appid 下用户唯一标识。
   */
  private String subOpenID;
  /**
   * 实际支付银行卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 30=贷记卡
   * 40=其他
   */
  private String actualCardType;
  /**
   * 转账识别码
   *
   * PaymentWay=50,且 Status=20时非空，为 O2O 支付转账识别码;
   */
  private String udID;
  /**
   * 用信申请URL
   *
   * PaymentWay=02, 为信用支付用信申请 H5 地址
   */
  private String creditPayURL;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应编号
   */
  private String responseCode;
  /**
   * 响应信息
   */
  private String responseMessage;


  public Tx5016Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.orderNo = XmlUtils.getNodeText(document, "OrderNo");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.amount = XmlUtils.getNodeText(document, "Amount");
      this.availableSplitAmount = XmlUtils.getNodeText(document, "AvailableSplitAmount");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.paymentWay = XmlUtils.getNodeText(document, "PaymentWay");
      this.payeeUserFee = XmlUtils.getNodeText(document, "PayeeUserFee");
      this.payerUserFee = XmlUtils.getNodeText(document, "PayerUserFee");
      this.qRPaymentType = XmlUtils.getNodeText(document, "QRPaymentType");
      this.qRPaymentWay = XmlUtils.getNodeText(document, "QRPaymentWay");
      this.bankTraceNo = XmlUtils.getNodeText(document, "BankTraceNo");
      this.traceNo = XmlUtils.getNodeText(document, "TraceNo");
      this.installmentBankID = XmlUtils.getNodeText(document, "InstallmentBankID");
      this.installmentPeriods = XmlUtils.getNodeText(document, "InstallmentPeriods");
      this.expireTime = XmlUtils.getNodeText(document, "ExpireTime");
      this.actualCardType = XmlUtils.getNodeText(document, "ActualCardType");
      this.applyCodeNO = XmlUtils.getNodeText(document, "ApplyCodeNO");
      this.udID = XmlUtils.getNodeText(document, "UdID");
      this.actualPayType = XmlUtils.getNodeText(document, "ActualPayType");
      this.payerAccountName = XmlUtils.getNodeText(document, "PayerAccountName");
      this.bankID = XmlUtils.getNodeText(document, "BankID");
      this.payerAccountNumber = XmlUtils.getNodeText(document, "PayerAccountNumber");
      this.payerBranchName = XmlUtils.getNodeText(document, "PayerBranchName");
      this.payerProvince = XmlUtils.getNodeText(document, "PayerProvince");
      this.payerCity = XmlUtils.getNodeText(document, "PayerCity");
      this.payerID = XmlUtils.getNodeText(document, "PayerID");
      this.orderType = XmlUtils.getNodeText(document, "OrderType");
      this.payeeName = XmlUtils.getNodeText(document, "PayeeName");
      this.payeeAccountNumber = XmlUtils.getNodeText(document, "PayeeAccountNumber");
      this.subOpenID = XmlUtils.getNodeText(document, "SubOpenID");
      this.creditPayURL = XmlUtils.getNodeText(document, "CreditPayURL");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
