package com.biz.crm.cpcnpay.core.tx.aggregate;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 5021-退款 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx5021Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 退款流水号
   */
  private String txSN;
  /**
   * 退款金额，单位:分
   */
  private String amount;
  /**
   * 撤销金额,单位:分
   */
  private String cancelAmount;
  /**
   * 返还收款用户手续费总金额, 单位:分
   */
  private String returnPayeeUserFee;
  /**
   * 退款状态
   *
   * 10=受理成功
   * 20=退款成功
   * 30=退款失败
   * 40=退票
   */
  private String status;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应编号
   */
  private String responseCode;
  /**
   * 响应信息
   */
  private String responseMessage;

  public Tx5021Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.amount = XmlUtils.getNodeText(document, "Amount");
      this.cancelAmount = XmlUtils.getNodeText(document, "CancelAmount");
      this.returnPayeeUserFee = XmlUtils.getNodeText(document, "ReturnPayeeUserFee");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
