package com.biz.crm.cpcnpay.core.tx.cancleAccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 5081-冻结订单分账撤销
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5086Request extends TxBaseRequest {
  /**
   * 分账撤销流水号
   */
  @NotBlank(message = "分账撤销流水号不能为空")
  private String txSN;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element txSN = document.createElement("TxSN");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(txSN);
    txSN.setTextContent(this.txSN);
    postProcess(document);
  }
}
