package com.biz.crm.cpcnpay.core.tx.foundationaccount;


import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import com.biz.crm.cpcnpay.core.vo.ShareholderPart;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.List;

/**
 * 4601-开户
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4601Request extends TxBaseRequest {
  /**
   * 开户流水号
   */
  @NotBlank(message = "开户流水号不能为空")
  private String txSN;
  /**
   * 用户 ID
   */
  @NotBlank(message = "用户ID不能为空")
  private String userID;
  /**
   * 归属父级用户 ID
   */
  private String parentUserID;
  /**
   * 用户类型:
   * <p>
   * 11=个人用户
   * 12=企业用户
   * 13=个体工商用户
   */
  @NotBlank(message = "用户类型不能为空")
  private String userType;
  /**
   * 确权方式
   * <p>
   * 第一位=数字证书 第二位=短信验证 第三位=邮件验证 第四位=支付密码 第五位=指纹 第六位=人脸识别 第七位=电子签名 第八位=默认自动支付 第九位=签约自动支付 说明:1 表示该确权信息上送，0 表示该确权信息未上送
   * 如 1011111，表示数字证书、短信验证、邮件验证、支付密码、指纹、电子签名 五种确权信息，而人脸识别、默认自动支付、签约自动支付不是上送确权信息中金账户必填
   */
  private String acceptanceConfirmType;
  /**
   * 账户层级:
   * <p>
   * 1=1级
   * 2=2级
   * 3=3级
   * 4=4级
   * 5=5级
   * 6=6级
   * 7=7级
   * 8=8级
   * 9=9级
   * 10=10级
   */
  private String accountLevel;
  /**
   * 影印件采集交易流水号
   */
  private String imageCollectionTxSN;
  /**
   * 后台通知地址
   */
  private String noticeURL;
  /**
   * 业务类型:
   * 10=开户
   * 20=开户并绑卡
   */
  private String businessType;
  /**
   * 开户手机号码
   */
  private String phoneNumber;
  /**
   * 用户姓名
   */
  private String userName;
  /**
   * 证件类型:
   * 0-身份证
   */
  private String credentialType;
  /**
   * 证件号码
   */
  private String credentialNumber;
  /**
   * 证件发证日
   * <p>
   * 注:格式: yyyyMMdd;亿联银行存管必填;
   */
  private String issDate;
  /**
   * 证件到期日
   * <p>
   * 注:当证件长期有效 时为 99991231;亿联银行存管必填;
   */
  private String expiryDate;
  /**
   * 联系地址
   * <p>
   * 注:常驻信息包括 (国家、省、市、 县、详细地址)
   */
  private String indAddress;
  /**
   * 个人邮箱
   */
  private String indEmail;
  /**
   * 身份证地址
   * <p>
   * 注:亿联银行存管必填
   */
  private String credentialAddress;
  /**
   * 职业:
   * <p>
   * 1A=各类专业，技术人员
   * 1B=国家机关，党群组织，企事业单位的负责人
   * 1C=办事人员和有关人员
   * 1D=商业工作人员
   * 1E=服务性工作人员
   * 1F=农林牧渔劳动者
   * 1G=生产工作，运输工作和部分体力劳动者
   * 1H=不便分类的其他劳动者
   */
  private String occupation;
  /**
   * 企业名称
   */
  private String corporationName;
  /**
   * 客户简称
   */
  private String corporationShort;
  /**
   * 分类类别
   */
  private String categoryType;
  /**
   * 企业邮箱
   */
  private String corEmail;
  /**
   * 企业地址
   */
  private String corAddress;
  /**
   * 省份
   */
  private String province;
  /**
   * 城市
   */
  private String city;
  /**
   * 区/县
   */
  private String district;
  /**
   * 行业代码
   */
  private String industryBelongType;
  /**
   * 通用行业代码
   */
  private String industry;
  /**
   * 企业规模:
   * <p>
   * 01=大型
   * 02=中型
   * 03=小型
   * 04=微型
   * 98=其他
   */
  private String scale;
  /**
   * 企业银行账户
   */
  private String basicAcctNo;
  /**
   * 开户许可证核准号
   * <p>
   * 注:众邦银行存管必填;
   */
  private String approvalNo;
  /**
   * 注册资本，单位分
   */
  private String authCapital;
  /**
   * 经营范围
   */
  private String businessScope;
  /**
   * 企业类型:
   * <p>
   * 01=企业单位
   * 02=民办非企业单位
   * <p>
   * 注:默认为 01-企业单位
   */
  private String corType;
  /**
   * 统一社会信息证代码
   */
  private String unifiedSocialCreditCode;
  /**
   * 统一社会信息证代码发证日
   * <p>
   * 注:格式: yyyyMMdd;
   */
  private String allLicenceIssDate;
  /**
   * 统一社会信息证代码有效期
   * <p>
   * 注:格式: yyyyMMdd;证件长期有效时为 20991231
   */
  private String allLicenceExpiryDate;
  /**
   * 法人姓名
   */
  private String legalPersonName;
  /**
   * 法人证件类型:
   * <p>
   * 0-身份证
   */
  private String legalCredentialType;
  /**
   * 法人证件号码
   */
  private String legalCredentialNumber;
  /**
   * 法人证件发证日
   * <p>
   * 注:格式: yyyyMMdd;
   */
  private String legalPersonIssDate;
  /**
   * 法人证件到期日
   * <p>
   * 注:当证件长期有效时为99991231
   */
  private String legalPersonExpiryDate;
  /**
   * 法人联系电话
   * <p>
   * 注:法人联系手机电话
   */
  private String legalPersonContactNumber;
  /**
   * 法人邮箱
   */
  private String legalPersonEmail;
  /**
   * 控股股东
   */
  private String shareholder;
  /**
   * 实际控制人
   */
  private String controller;
  /**
   * 实际收益人
   */
  private String beneficiary;
  /**
   * 控股股东姓名
   * <p>
   * 注:亿联银行必填; 出现小于等于 3 次;
   */
  private List<ShareholderPart> shareholderPartsList;
  /**
   * 经营者姓名
   */
  private String managerName;
  /**
   * 经营者证件类型:
   * <p>
   * 0-身份证
   */
  private String managerCredentialType;
  /**
   * 经营者证件号码
   */
  private String managerCredentialNumber;
  /**
   * 经营者证件发证日
   * <p>
   * 注:格式: yyyyMMdd;
   */
  private String managerIssDate;
  /**
   * 经营者证件到期日
   * <p>
   * 注:格式: yyyyMMdd;证件长期有效时为20991231
   */
  private String managerExpiryDate;
  /**
   * 经营者手机号码
   */
  private String managerContactNumber;
  /**
   * 经营者邮箱
   * <p>
   * 注:银行存管模式必填;
   */
  private String managerEmail;
  /**
   * 经营者身份证地址
   */
  private String managerCredentialAddress;
  /**
   * 经营者职业:
   * <p>
   * 1A=各类专业，技术人员
   * 1B=国家机关， 党群组织，企事业单位的负责人
   * 1C=办事人员和有关人员
   * 1D=商业工作人员
   * 1E=服务性工作人员
   * 1F=农林牧渔劳动者
   * 1G=生产工作，运输工作和部分体力劳动者
   * 1H=不便分类的其他劳动者
   */

  private String managerOccupation;
  /**
   * 个体工商注册号码
   */
  private String retailerRegNumber;
  /**
   * 个体工商字号
   * <p>
   * 注:营业执照名称;
   */
  private String retailerName;
  /**
   * 个体工商执照发证日
   * <p>
   * 注:格式: yyyyMMdd;
   */
  private String retailerLicenseIssDate;
  /**
   * 个体工商执照到期日
   * <p>
   * 注:格式: yyyyMMdd;证件长期有效时为 20991231
   */
  private String retailerLicenseExpiryDate;
  /**
   * 组成形式:
   * <p>
   * 10=个人经营
   * 20=家庭经营
   */
  private String retailerFormation;
  /**
   * 经营地址
   */
  private String retailerAddress;
  /**
   * 城市
   */
  private String retailerProvince;
  /**
   * 城市
   */
  private String retailerCity;
  /**
   * 区/县
   */
  private String retailerDistrict;
  /**
   * 经营范围
   */
  private String retailerBusinessScope;
  /**
   * 银行账户绑定流水号
   * <p>
   * 注:流水号前 17 位必须是时间戳 (yyyyMMddHHmmssSSS，数字)
   */
  private String bindingTxSN;
  /**
   * 绑定银行 ID
   */
  private String bankID;
  /**
   * 银行账户号码
   */
  private String bankAccountNumber;
  /**
   * 银行卡预留手机号码
   */
  private String bankPhoneNumber;
  /**
   * 人民银行联行号
   */
  private String cNAPSCode;
  /**
   * 分支行名称
   */
  private String branchName;
  /**
   * 省份
   */
  private String bankProvince;
  /**
   * 城市
   */
  private String bankCity;

 //======================2025年1月23日==============================

  /**
   * 经办人姓名
   */
 private String consigneeName;
 /**
   * 经办人证件类型
   */
 private String consigneeCredentialType;
 /**
   * 经办人证件号码
   */
 private String consigneeCredentialNumber;
 /**
   * 经办人证件有效期起始
   */
 private String consigneeIssDate;
 /**
   * 经办人证件有效期结束
   */
 private String consigneeExpiryDate;
 /**
   * 经办人手机号码
   */
 private String consigneeContactNumber;




  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element UserID = document.createElement("UserID");
    Element ParentUserID = document.createElement("ParentUserID");
    Element UserType = document.createElement("UserType");
    Element AcceptanceConfirmType = document.createElement("AcceptanceConfirmType");
    Element AccountLevel = document.createElement("AccountLevel");
    Element ImageCollectionTxSN = document.createElement("ImageCollectionTxSN");
    Element NoticeURL = document.createElement("NoticeURL");
    Element BusinessType = document.createElement("BusinessType");
    Element Individual = document.createElement("Individual");
    Element PhoneNumber = document.createElement("PhoneNumber");
    Element UserName = document.createElement("UserName");
    Element CredentialType = document.createElement("CredentialType");
    Element CredentialNumber = document.createElement("CredentialNumber");
    Element IssDate = document.createElement("IssDate");
    Element ExpiryDate = document.createElement("ExpiryDate");
    Element IndAddress = document.createElement("IndAddress");
    Element IndEmail = document.createElement("IndEmail");
    Element CredentialAddress = document.createElement("CredentialAddress");
    Element Occupation = document.createElement("Occupation");
    Element Corporation = document.createElement("Corporation");
    Element CorporationName = document.createElement("CorporationName");
    Element CorporationShort = document.createElement("CorporationShort");
    Element CategoryType = document.createElement("CategoryType");
    Element CorEmail = document.createElement("CorEmail");
    Element CorAddress = document.createElement("CorAddress");
    Element Province = document.createElement("Province");
    Element City = document.createElement("City");
    Element District = document.createElement("District");
    Element IndustryBelongType = document.createElement("IndustryBelongType");
    Element Industry = document.createElement("Industry");
    Element Scale = document.createElement("Scale");
    Element BasicAcctNo = document.createElement("BasicAcctNo");
    Element ApprovalNo = document.createElement("ApprovalNo");
    Element AuthCapital = document.createElement("AuthCapital");
    Element BusinessScope = document.createElement("BusinessScope");
    Element CorType = document.createElement("CorType");
    Element UnifiedSocialCreditCode = document.createElement("UnifiedSocialCreditCode");
    Element AllLicenceIssDate = document.createElement("AllLicenceIssDate");
    Element AllLicenceExpiryDate = document.createElement("AllLicenceExpiryDate");
    Element LegalPersonName = document.createElement("LegalPersonName");
    Element LegalCredentialType = document.createElement("LegalCredentialType");
    Element LegalCredentialNumber = document.createElement("LegalCredentialNumber");
    Element LegalPersonIssDate = document.createElement("LegalPersonIssDate");
    Element LegalPersonExpiryDate = document.createElement("LegalPersonExpiryDate");
    Element LegalPersonContactNumber = document.createElement("LegalPersonContactNumber");
    Element LegalPersonEmail = document.createElement("LegalPersonEmail");
    Element Shareholder = document.createElement("Shareholder");
    Element Controller = document.createElement("Controller");
    Element Beneficiary = document.createElement("Beneficiary");
    Element Retailer = document.createElement("Retailer");
    Element ManagerName = document.createElement("ManagerName");
    Element ManagerCredentialType = document.createElement("ManagerCredentialType");
    Element ManagerCredentialNumber = document.createElement("ManagerCredentialNumber");
    Element ManagerIssDate = document.createElement("ManagerIssDate");
    Element ManagerExpiryDate = document.createElement("ManagerExpiryDate");
    Element ManagerContactNumber = document.createElement("ManagerContactNumber");
    Element ManagerEmail = document.createElement("ManagerEmail");
    Element ManagerCredentialAddress = document.createElement("ManagerCredentialAddress");
    Element ManagerOccupation = document.createElement("ManagerOccupation");
    Element RetailerRegNumber = document.createElement("RetailerRegNumber");
    Element RetailerName = document.createElement("RetailerName");
    Element RetailerLicenseIssDate = document.createElement("RetailerLicenseIssDate");
    Element RetailerLicenseExpiryDate = document.createElement("RetailerLicenseExpiryDate");
    Element RetailerFormation = document.createElement("RetailerFormation");
    Element RetailerAddress = document.createElement("RetailerAddress");
    Element RetailerProvince = document.createElement("RetailerProvince");
    Element RetailerCity = document.createElement("RetailerCity");
    Element RetailerDistrict = document.createElement("RetailerDistrict");
    Element RetailerBusinessScope = document.createElement("RetailerBusinessScope");
    Element BankAccount = document.createElement("BankAccount");
    Element BindingTxSN = document.createElement("BindingTxSN");
    Element BankID = document.createElement("BankID");
    Element BankAccountNumber = document.createElement("BankAccountNumber");
    Element BankPhoneNumber = document.createElement("BankPhoneNumber");
    Element CNAPSCode = document.createElement("CNAPSCode");
    Element BranchName = document.createElement("BranchName");
    Element BankProvince = document.createElement("BankProvince");
    Element BankCity = document.createElement("BankCity");

    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(ParentUserID);
    ParentUserID.setTextContent(this.parentUserID);
    Body.appendChild(UserType);
    UserType.setTextContent(this.userType);
    Body.appendChild(AcceptanceConfirmType);
    AcceptanceConfirmType.setTextContent(this.acceptanceConfirmType);
    Body.appendChild(AccountLevel);
    AccountLevel.setTextContent(this.accountLevel);
    Body.appendChild(ImageCollectionTxSN);
    ImageCollectionTxSN.setTextContent(this.imageCollectionTxSN);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(BusinessType);
    BusinessType.setTextContent(this.businessType);
    if (this.userType.equals("11")) {
      Body.appendChild(Individual);
      Individual.appendChild(PhoneNumber);
      PhoneNumber.setTextContent(this.phoneNumber);
      Individual.appendChild(UserName);
      UserName.setTextContent(this.userName);
      Individual.appendChild(CredentialType);
      CredentialType.setTextContent(this.credentialType);
      Individual.appendChild(CredentialNumber);
      CredentialNumber.setTextContent(this.credentialNumber);
      Individual.appendChild(IssDate);
      IssDate.setTextContent(this.issDate);
      Individual.appendChild(ExpiryDate);
      ExpiryDate.setTextContent(this.expiryDate);
      Individual.appendChild(IndAddress);
      IndAddress.setTextContent(this.indAddress);
      Individual.appendChild(IndEmail);
      IndEmail.setTextContent(this.indEmail);
      Individual.appendChild(CredentialAddress);
      CredentialAddress.setTextContent(this.credentialAddress);
      Individual.appendChild(Occupation);
      Occupation.setTextContent(this.occupation);
    } else if (this.userType.equals("12")) {
      Body.appendChild(Corporation);
      Corporation.appendChild(CorporationName);
      CorporationName.setTextContent(this.corporationName);
      Corporation.appendChild(CorporationShort);
      CorporationShort.setTextContent(this.corporationShort);
      Corporation.appendChild(CategoryType);
      CategoryType.setTextContent(this.categoryType);
      Corporation.appendChild(CorEmail);
      CorEmail.setTextContent(this.corEmail);
      Corporation.appendChild(CorAddress);
      CorAddress.setTextContent(this.corAddress);
      Corporation.appendChild(Province);
      Province.setTextContent(this.province);
      Corporation.appendChild(City);
      City.setTextContent(this.city);
      Corporation.appendChild(District);
      District.setTextContent(this.district);
      Corporation.appendChild(IndustryBelongType);
      IndustryBelongType.setTextContent(this.industryBelongType);
      Corporation.appendChild(Industry);
      Industry.setTextContent(this.industry);
      Corporation.appendChild(Scale);
      Scale.setTextContent(this.scale);
      Corporation.appendChild(BasicAcctNo);
      BasicAcctNo.setTextContent(this.basicAcctNo);
      Corporation.appendChild(ApprovalNo);
      ApprovalNo.setTextContent(this.approvalNo);
      Corporation.appendChild(AuthCapital);
      AuthCapital.setTextContent(this.authCapital);
      Corporation.appendChild(BusinessScope);
      BusinessScope.setTextContent(this.businessScope);
      Corporation.appendChild(CorType);
      CorType.setTextContent(this.corType);
      Corporation.appendChild(UnifiedSocialCreditCode);
      UnifiedSocialCreditCode.setTextContent(this.unifiedSocialCreditCode);
      Corporation.appendChild(AllLicenceIssDate);
      AllLicenceIssDate.setTextContent(this.allLicenceIssDate);
      Corporation.appendChild(AllLicenceExpiryDate);
      AllLicenceExpiryDate.setTextContent(this.allLicenceExpiryDate);
      Corporation.appendChild(LegalPersonName);
      LegalPersonName.setTextContent(this.legalPersonName);
      Corporation.appendChild(LegalCredentialType);
      LegalCredentialType.setTextContent(this.legalCredentialType);
      Corporation.appendChild(LegalCredentialNumber);
      LegalCredentialNumber.setTextContent(this.legalCredentialNumber);
      Corporation.appendChild(LegalPersonIssDate);
      LegalPersonIssDate.setTextContent(this.legalPersonIssDate);
      Corporation.appendChild(LegalPersonExpiryDate);
      LegalPersonExpiryDate.setTextContent(this.legalPersonExpiryDate);
      Corporation.appendChild(LegalPersonContactNumber);
      LegalPersonContactNumber.setTextContent(this.legalPersonContactNumber);
      Corporation.appendChild(LegalPersonEmail);
      LegalPersonEmail.setTextContent(this.legalPersonEmail);
      Corporation.appendChild(Shareholder);
      Shareholder.setTextContent(this.shareholder);
      Corporation.appendChild(Controller);
      Controller.setTextContent(this.controller);
      Corporation.appendChild(Beneficiary);
      Beneficiary.setTextContent(this.beneficiary);
      if (this.shareholderPartsList != null && this.shareholderPartsList.size() > 0) {
        for (ShareholderPart shareholderPart : this.shareholderPartsList) {
          Element ShareholderPart = document.createElement("ShareholderPart");
          Element ShareholderName = document.createElement("ShareholderName");
          Element ShCredentialType = document.createElement("ShCredentialType");
          Element ShCredentialNumber = document.createElement("ShCredentialNumber");
          Element ShPersonIssDate = document.createElement("ShPersonIssDate");
          Element ShPersonExpiryDate = document.createElement("ShPersonExpiryDate");
          Corporation.appendChild(ShareholderPart);
          ShareholderPart.appendChild(ShareholderName);
          ShareholderName.setTextContent(shareholderPart.getShareholderName());
          ShareholderPart.appendChild(ShCredentialType);
          ShCredentialType.setTextContent(shareholderPart.getShCredentialType());
          ShareholderPart.appendChild(ShCredentialNumber);
          ShCredentialNumber.setTextContent(shareholderPart.getShCredentialNumber());
          ShareholderPart.appendChild(ShPersonIssDate);
          ShPersonIssDate.setTextContent(shareholderPart.getShPersonIssDate());
          ShareholderPart.appendChild(ShPersonExpiryDate);
          ShPersonExpiryDate.setTextContent(shareholderPart.getShPersonExpiryDate());
        }
      }

      //当法人证件类型是港澳台证件时需要添加经办人信息
      if("5".equals(this.legalCredentialType)||"6".equals(this.legalCredentialType)) {
        //经办人信息
        Element ConsigneeName = document.createElement("ConsigneeName");
        Element ConsigneeCredentialType = document.createElement("ConsigneeCredentialType");
        Element ConsigneeCredentialNumber = document.createElement("ConsigneeCredentialNumber");
        Element ConsigneeIssDate = document.createElement("ConsigneeIssDate");
        Element ConsigneeExpiryDate = document.createElement("ConsigneeExpiryDate");
        Element ConsigneeContactNumber = document.createElement("ConsigneeContactNumber");
        Corporation.appendChild(ConsigneeName);
        ConsigneeName.setTextContent(this.consigneeName);
        Corporation.appendChild(ConsigneeCredentialType);
        ConsigneeCredentialType.setTextContent(this.consigneeCredentialType);
        Corporation.appendChild(ConsigneeCredentialNumber);
        ConsigneeCredentialNumber.setTextContent(this.consigneeCredentialNumber);
        Corporation.appendChild(ConsigneeIssDate);
        ConsigneeIssDate.setTextContent(this.consigneeIssDate);
        Corporation.appendChild(ConsigneeExpiryDate);
        ConsigneeExpiryDate.setTextContent(this.consigneeExpiryDate);
        Corporation.appendChild(ConsigneeContactNumber);
        ConsigneeContactNumber.setTextContent(this.consigneeContactNumber);
      }
    } else if (this.userType.equals("13")) {
      Body.appendChild(Retailer);
      Retailer.appendChild(ManagerName);
      ManagerName.setTextContent(this.managerName);
      Retailer.appendChild(ManagerCredentialType);
      ManagerCredentialType.setTextContent(this.managerCredentialType);
      Retailer.appendChild(ManagerCredentialNumber);
      ManagerCredentialNumber.setTextContent(this.managerCredentialNumber);
      Retailer.appendChild(ManagerIssDate);
      ManagerIssDate.setTextContent(this.managerIssDate);
      Retailer.appendChild(ManagerExpiryDate);
      ManagerExpiryDate.setTextContent(this.managerExpiryDate);
      Retailer.appendChild(ManagerContactNumber);
      ManagerContactNumber.setTextContent(this.managerContactNumber);
      Retailer.appendChild(ManagerEmail);
      ManagerEmail.setTextContent(this.managerEmail);
      Retailer.appendChild(ManagerCredentialAddress);
      ManagerCredentialAddress.setTextContent(this.managerCredentialAddress);
      Retailer.appendChild(ManagerOccupation);
      ManagerOccupation.setTextContent(this.managerOccupation);
      Retailer.appendChild(RetailerRegNumber);
      RetailerRegNumber.setTextContent(this.retailerRegNumber);
      Retailer.appendChild(RetailerName);
      RetailerName.setTextContent(this.retailerName);
      Retailer.appendChild(RetailerLicenseIssDate);
      RetailerLicenseIssDate.setTextContent(this.retailerLicenseIssDate);
      Retailer.appendChild(RetailerLicenseExpiryDate);
      RetailerLicenseExpiryDate.setTextContent(this.retailerLicenseExpiryDate);
      Retailer.appendChild(RetailerFormation);
      RetailerFormation.setTextContent(this.retailerFormation);
      Retailer.appendChild(RetailerAddress);
      RetailerAddress.setTextContent(this.retailerAddress);
      Retailer.appendChild(RetailerProvince);
      RetailerProvince.setTextContent(this.retailerProvince);
      Retailer.appendChild(RetailerCity);
      RetailerCity.setTextContent(this.retailerCity);
      Retailer.appendChild(RetailerDistrict);
      RetailerDistrict.setTextContent(this.retailerDistrict);
      Retailer.appendChild(RetailerBusinessScope);
      RetailerBusinessScope.setTextContent(this.retailerBusinessScope);
    }
    if ("20".equals(this.businessType)) {
      Body.appendChild(BankAccount);
      BankAccount.appendChild(BindingTxSN);
      BindingTxSN.setTextContent(this.bindingTxSN);
      BankAccount.appendChild(BankID);
      BankID.setTextContent(this.bankID);
      BankAccount.appendChild(BankAccountNumber);
      BankAccountNumber.setTextContent(this.bankAccountNumber);
      BankAccount.appendChild(BankPhoneNumber);
      BankPhoneNumber.setTextContent(this.bankPhoneNumber);
      BankAccount.appendChild(CNAPSCode);
      CNAPSCode.setTextContent(this.cNAPSCode);
      BankAccount.appendChild(BranchName);
      BranchName.setTextContent(this.branchName);
      BankAccount.appendChild(BankProvince);
      BankProvince.setTextContent(this.bankProvince);
      BankAccount.appendChild(BankCity);
      BankCity.setTextContent(this.bankCity);
    }
    postProcess(document);
  }
}
