package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4643-提现(API)
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4643Request extends TxBaseRequest {
  /**
   * 交易流水号
   */
  @NotBlank(message = "交易流水号不能为空")
  private String txSN;
  /**
   * 用户 ID
   */
  @NotBlank(message = "用户 ID不能为空")
  private String userID;
  /**
   * 确权方式
   *
   * 确权方式 第一位=数字证书 第二位=短信验证 第三位=邮件验证 第四位=支付密码 第五位=指纹 第六位=人脸识别 第七位=电子签名 第八位=默认自动支付 第九位=签约自动支付说明:1 表示该确权信息上送，0 表示该确权信息未上送
   * 如 1011111，表示数字证 书、短信验证、邮件验证、支付密码、指纹、电子签名五种确权信息，而人脸识别、默认自动支付、签约自动支付不是上送确权信息中金账户必填
   */
  private String acceptanceConfirmType;
  /**
   * 已绑定银行账户流水号
   */
  @NotBlank(message = "已绑定银行账户流水号不能为空")
  private String bindingTxSN;
  /**
   * 提现金额
   *
   * 注:单位:分
   */
  @NotBlank(message = "提现金额不能为空")
  private String amount;
  /**
   * 到账类型
   *
   * 10=T+1
   * 20=D0
   *
   * 注:T+1:下一个工作日到账
   */
  @NotBlank(message = "到账类型不能为空")
  private String arrivalType;
  /**
   * 注:商户上传已这个地址为准，商户未上传一机构配置后台通知为准
   */
  private String noticeURL;
  /**
   * 备注
   */
  private String remark;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element UserID = document.createElement("UserID");
    Element AcceptanceConfirmType = document.createElement("AcceptanceConfirmType");
    Element BindingTxSN = document.createElement("BindingTxSN");
    Element Amount = document.createElement("Amount");
    Element ArrivalType = document.createElement("ArrivalType");
    Element NoticeURL = document.createElement("NoticeURL");
    Element Remark = document.createElement("Remark");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(AcceptanceConfirmType);
    AcceptanceConfirmType.setTextContent(this.acceptanceConfirmType);
    Body.appendChild(BindingTxSN);
    BindingTxSN.setTextContent(this.bindingTxSN);
    Body.appendChild(Amount);
    Amount.setTextContent(this.amount);
    Body.appendChild(ArrivalType);
    ArrivalType.setTextContent(this.arrivalType);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(Remark);
    Remark.setTextContent(this.remark);
    postProcess(document);
  }
}
