package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;


/**
 * 4691-用户信息查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4691Response extends TxBaseResponse {
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 归属父级用户 ID
   */
  private String parentUserID;
  /**
   * 可用账户余额
   * <p>
   * 注:单位:分
   */
  private String balance;
  /**
   * 到账余额
   */
  private String receivedBalance;
  /**
   * 在途余额
   */
  private String receivableBalance;
  /**
   * 冻结账户余额
   */
  private String frozenAmount;
  /**
   * 用户类型:
   * <p>
   * 10=个人用户
   * 15=个体工商户用户
   * 20=企业用户
   * 40=匿名用户
   */
  private String userType;
  /**
   * 账户状态:
   * <p>
   * 10=正常
   * 30=冻结
   * 35=止付
   */
  private String status;

  public Tx4691Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.userName = XmlUtils.getNodeText(document, "UserName");
      this.userID = XmlUtils.getNodeText(document, "UserID");
      this.parentUserID = XmlUtils.getNodeText(document, "ParentUserID");
      this.balance = XmlUtils.getNodeText(document, "Balance");
      this.receivedBalance = XmlUtils.getNodeText(document, "ReceivedBalance");
      this.receivableBalance = XmlUtils.getNodeText(document, "ReceivableBalance");
      this.frozenAmount = XmlUtils.getNodeText(document, "FrozenAmount");
      this.userType = XmlUtils.getNodeText(document, "UserType");
      this.status = XmlUtils.getNodeText(document, "Status");
    }
  }

}
