/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.common.http;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.cpcnpay.common.http.NameValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpData {
    private Logger log = LoggerFactory.getLogger(HttpData.class);
    private List<NameValuePair> params;
    private String charset;

    public HttpData(List<NameValuePair> params, String charset) {
        this.params = params;
        this.charset = charset;
    }

    public String getData() {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtil.isEmpty(this.params)) {
            for (NameValuePair nv : this.params) {
                try {
                    sb.append(String.format("%s=%s&", nv.getName(), URLEncoder.encode(nv.getValue(), this.charset)));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error("\u8bf7\u6c42\u53c2\u6570\u8f6c\u5316\u9519\u8bef", (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            }
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        return "";
    }
}

