/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.common.http.internal;

import com.biz.crm.cpcnpay.common.http.HttpConnection;
import com.biz.crm.cpcnpay.common.http.HttpData;
import com.biz.crm.cpcnpay.common.http.NameValuePair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpConnection
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpConnection.class);
    private String method = "POST";
    private int connectTimeout = 50000;
    private int readTimeout = 50000;
    private String outputCharset = "UTF-8";
    private String inputCharset = "UTF-8";
    private String contentType = "application/x-www-form-urlencoded";

    @Override
    public String execute(String uri, List<NameValuePair> list) {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        return this.execute(uri, request);
    }

    @Override
    public String execute(String uri, String request) {
        String response;
        HttpURLConnection httpUrlConnection;
        try {
            URL url = new URL(uri);
            httpUrlConnection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u7f51\u7edc\u8fde\u63a5\u9519\u8bef", e);
        }
        httpUrlConnection.setRequestProperty("Content-Type", this.contentType);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        try {
            httpUrlConnection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b[%s]", this.method), e);
        }
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setConnectTimeout(this.connectTimeout);
        httpUrlConnection.setReadTimeout(this.readTimeout);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = httpUrlConnection.getOutputStream();
            outputStream.write(request.getBytes(this.outputCharset));
            outputStream.flush();
            outputStream.close();
            inputStream = httpUrlConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            response = baos.toString(this.inputCharset).trim();
            inputStream.close();
        }
        catch (IOException e) {
            log.error("\u53d1\u9001\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            throw new RuntimeException("\u53d1\u9001\u8bf7\u6c42\u51fa\u9519", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
        return response;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setOutputCharset(String outputCharset) {
        this.outputCharset = outputCharset;
    }

    @Override
    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

