/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.configuration;

import cfca.sadk.util.CertUtil;
import cfca.sadk.x509.certificate.X509Cert;
import com.biz.crm.cpcnpay.common.http.HttpsConnection;
import com.biz.crm.cpcnpay.common.http.SecurityContext;
import com.biz.crm.cpcnpay.common.http.internal.HttpsClientConnection;
import com.biz.crm.cpcnpay.common.http.internal.SimpleHttpsConnection;
import com.biz.crm.cpcnpay.common.security.CertificateVerifier;
import com.biz.crm.cpcnpay.common.security.PfxSigner;
import com.biz.crm.cpcnpay.common.security.SMSigner;
import com.biz.crm.cpcnpay.common.security.SMVerifier;
import com.biz.crm.cpcnpay.common.security.Signer;
import com.biz.crm.cpcnpay.common.security.Verifier;
import com.biz.crm.cpcnpay.core.common.enums.CpcnEncryptType;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.configuration.CpcnProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@ComponentScan(basePackages={"com.biz.crm.cpcnpay"})
@Configuration
@EnableConfigurationProperties(value={CpcnProperties.class})
@ConditionalOnProperty(prefix="pay.cpcn", name={"enabled"}, havingValue="true")
public class CpcnAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CpcnAutoConfiguration.class);
    @Resource
    private CpcnProperties cpcnProperties;

    @Bean
    @ConditionalOnMissingBean(value={CpcnConfig.class})
    public CpcnConfig getCpcnConfig() throws Exception {
        CpcnConfig cpcnConfig = new CpcnConfig();
        Validate.notBlank((CharSequence)this.cpcnProperties.getEncryptType(), (String)"\u52a0\u5bc6\u7c7b\u578b\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getPriKey(), (String)"\u5e73\u53f0\u79c1\u94a5\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getPubKey(), (String)"\u5e73\u53f0\u516c\u94a5\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getPaymentUrl(), (String)"\u652f\u4ed8\u5e73\u53f0\u652f\u4ed8\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getTxUrl(), (String)"\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getGateway4fileUrl(), (String)"Gateway4File\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getAlgorithm(), (String)"\u652f\u4ed8\u5e73\u53f0\u52a0\u5bc6\u7b97\u6cd5\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getInstitutionID(), (String)"\u652f\u4ed8\u5e73\u53f0\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getPassword(), (String)"\u652f\u4ed8\u5e73\u53f0\u79c1\u94a5\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getNoticeUrl(), (String)"\u652f\u4ed8\u5e73\u53f0\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getTrustKey(), (String)"SSL\u8bf7\u6c42\u8bc1\u4e66\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getTrustPassword(), (String)"SSL\u8bf7\u6c42\u8bc1\u4e66\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.cpcnProperties.getPlatformName(), (String)"\u5e73\u53f0\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        SecurityContext.initSSLSocketFactory(this.getFilePath(this.cpcnProperties.getTrustKey()), this.cpcnProperties.getTrustPassword());
        Signer signer = null;
        Verifier verifier = null;
        if (CpcnEncryptType.INTERNATIONAL_ENCRYPT.getCode().equals(this.cpcnProperties.getEncryptType())) {
            signer = new PfxSigner(this.getFilePath(this.cpcnProperties.getPriKey()), this.cpcnProperties.getPassword(), this.cpcnProperties.getAlgorithm());
            verifier = new CertificateVerifier(this.getFilePath(this.cpcnProperties.getPubKey()), this.cpcnProperties.getAlgorithm());
        } else if (CpcnEncryptType.NATIONAL_ENCRYPT.getCode().equals(this.cpcnProperties.getEncryptType())) {
            signer = new SMSigner(this.getFilePath(this.cpcnProperties.getPriKey()), this.cpcnProperties.getPassword());
            X509Cert x509Cert = CertUtil.getCertFromSM2((String)this.getFilePath(this.cpcnProperties.getPriKey()));
            verifier = new SMVerifier(x509Cert);
        }
        cpcnConfig.setSigner(signer);
        cpcnConfig.setVerifier(verifier);
        cpcnConfig.setAlgorithm(this.cpcnProperties.getAlgorithm());
        cpcnConfig.setInstitutionID(this.cpcnProperties.getInstitutionID());
        cpcnConfig.setPaymentUrl(this.cpcnProperties.getPaymentUrl());
        cpcnConfig.setTxUrl(this.cpcnProperties.getTxUrl());
        cpcnConfig.setPassword(this.cpcnProperties.getPassword());
        cpcnConfig.setNoticeUrl(this.cpcnProperties.getNoticeUrl());
        cpcnConfig.setGateway4fileUrl(this.cpcnProperties.getGateway4fileUrl());
        cpcnConfig.setGateway4aggregatePaymentUrl(this.cpcnProperties.getGateway4aggregatePaymentUrl());
        cpcnConfig.setGateway4aggregateTxUrl(this.cpcnProperties.getGateway4aggregateTxUrl());
        cpcnConfig.setPlatformName(this.cpcnProperties.getPlatformName());
        cpcnConfig.setDebug(this.cpcnProperties.isDebug());
        log.debug("***\u4e2d\u91d1\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u52a0\u8f7d\u5b8c\u6210***");
        return cpcnConfig;
    }

    private String getFilePath(String path) throws FileNotFoundException {
        File file = ResourceUtils.getFile((String)path);
        Validate.notNull((Object)file, (String)String.format("\u52a0\u8f7d\u6587\u4ef6\u3010%s\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", path), (Object[])new Object[0]);
        return file.getAbsolutePath();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpsConnection.class})
    @ConditionalOnClass(value={HttpClient.class})
    public HttpsConnection getHttpsClientConnection() {
        HttpsClientConnection httpsConnection = new HttpsClientConnection();
        return httpsConnection;
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpsConnection.class})
    public HttpsConnection getHttpsConnection() {
        SimpleHttpsConnection httpsConnection = new SimpleHttpsConnection();
        return httpsConnection;
    }

    @Bean
    @ConditionalOnMissingBean(value={ValidatorFactory.class})
    public ValidatorFactory getLocalValidatorFactoryBean() {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        return validatorFactory;
    }

    @Bean
    public CloseableHttpClient httpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContextBuilder builder = SSLContexts.custom();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLContext sslContext = builder.build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }

            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        return httpclient;
    }

    @Bean(value={"defaultRemoteNoticeExecutor"})
    @ConditionalOnMissingBean(name={"defaultRemoteNoticeExecutor"})
    public ThreadPoolExecutor getDefaultDatasourceExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(2, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new DefaultRemoteNoticeThreadFactory());
        return threadPoolExecutor;
    }

    private class DefaultRemoteNoticeThreadFactory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger(0);

        private DefaultRemoteNoticeThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = "defaultRemoteNotice-thread-" + this.count.incrementAndGet();
            Thread defaultRemoteNoticeThread = new Thread(r, threadName);
            return defaultRemoteNoticeThread;
        }
    }
}

