/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.notice;

import cfca.sadk.util.Base64;
import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import java.nio.charset.StandardCharsets;
import org.w3c.dom.Document;

public class NoticeRequest {
    private String plainText;
    private Document document;
    private String txCode;
    private CpcnConfig cpcnConfig;
    private String message;

    public NoticeRequest(String message, String signature, CpcnConfig cpcnConfig) throws Exception {
        this.cpcnConfig = cpcnConfig;
        this.message = message;
        this.plainText = new String(Base64.decode((String)message), StandardCharsets.UTF_8);
        this.document = XmlUtils.createDocument(this.plainText);
        this.txCode = XmlUtils.getNodeText(this.document, "TxCode");
    }

    public String getPlainText() {
        return this.plainText;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public CpcnConfig getCpcnConfig() {
        return this.cpcnConfig;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "NoticeRequest(plainText=" + this.getPlainText() + ", document=" + this.getDocument() + ", txCode=" + this.getTxCode() + ", cpcnConfig=" + this.getCpcnConfig() + ", message=" + this.getMessage() + ")";
    }
}

