/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityService;
import com.biz.crm.cps.business.activity.scan.sdk.constant.ScanActivityConstant;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u626b\u7801\u6d3b\u52a8: ScanActivity: \u626b\u7801\u6d3b\u52a8"})
@RestController
@RequestMapping(value={"/v1/scanActivity/scanActivity"})
public class ScanActivityController {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityController.class);
    @Autowired
    private ScanActivityService scanActivityService;
    @Autowired
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ScanActivity>> findByConditions(@PageableDefault(value=50) Pageable pageable, ScanActivityPaginationDto paginationDto) {
        try {
            Page<ScanActivity> result = this.scanActivityService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u542f\u7528")
    @GetMapping(value={"/enable"})
    public Result enable(@RequestParam(value="id") String id) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("scanActivityLockKey", TimeUnit.SECONDS, ScanActivityConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u626b\u7801\u6d3b\u52a8\u76f8\u5173\u7f16\u8f91\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.scanActivityService.enable(id);
            Result result = Result.ok((String)"\u542f\u7528\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("scanActivityLockKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7981\u7528")
    @GetMapping(value={"/disable"})
    public Result disable(@RequestParam(value="id") String id) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("scanActivityLockKey", TimeUnit.SECONDS, ScanActivityConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u626b\u7801\u6d3b\u52a8\u76f8\u5173\u7f16\u8f91\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.scanActivityService.disable(id);
            Result result = Result.ok((String)"\u7981\u7528\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("scanActivityLockKey");
        }
    }
}

