/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ParticipateActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityListVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u626b\u7801\u6d3b\u52a8: ScanActivityListVo: \u626b\u7801\u6d3b\u52a8\u5206\u9875\u5217\u8868"})
@RestController
@RequestMapping(value={"/v1/scanActivity/scanActivityListVo"})
public class ScanActivityListVoController {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityListVoController.class);
    @Autowired
    private ScanActivityListVoService scanActivityListVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ScanActivityListVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ScanActivityListPaginationDto paginationDto) {
        try {
            Page result = this.scanActivityListVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u53c2\u4e0e\u4eba\u6570")
    @GetMapping(value={"/findParticipateNumsByCode"})
    public Result<Map<String, String>> findParticipateNumsByCode(@RequestParam(value="code") String code) {
        try {
            String num = this.scanActivityListVoService.findParticipateNumsByCode(code);
            HashMap map = Maps.newHashMap();
            map.put("num", num);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53c2\u4e0e\u6d3b\u52a8")
    @PostMapping(value={"/participateActivity"})
    public Result participateActivity(@RequestBody ParticipateActivityDto dto) {
        try {
            this.scanActivityListVoService.participateActivity(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

