/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.controller;

import com.biz.crm.cps.business.activity.scan.sdk.constant.ScanActivityConstant;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u626b\u7801\u6d3b\u52a8: ScanActivityVo: \u626b\u7801\u6d3b\u52a8"})
@RestController
@RequestMapping(value={"/v1/scanActivity/scanActivity"})
public class ScanActivityVoController {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityVoController.class);
    @Autowired
    private ScanActivityVoService scanActivityVoService;
    @Autowired
    private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;
    @Autowired
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ScanActivityVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            ScanActivityVo vo = this.scanActivityVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u83b7\u53d6\u53c2\u4e0e\u660e\u7ec6\u6d3b\u52a8\u7684\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<ScanActivityVo> findById(@RequestParam(value="id") String id) {
        try {
            ScanActivityVo vo = this.scanActivityVoService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={""})
    public Result<ScanActivityVo> create(@RequestBody ScanActivityDto dto) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("scanActivityLockKey", TimeUnit.SECONDS, ScanActivityConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u626b\u7801\u6d3b\u52a8\u76f8\u5173\u7f16\u8f91\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            ScanActivityVo current = this.scanActivityVoService.create(dto);
            Result result = Result.ok((Object)current);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("scanActivityLockKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping(value={""})
    public Result<ScanActivityVo> update(@RequestBody ScanActivityDto dto) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("scanActivityLockKey", TimeUnit.SECONDS, ScanActivityConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u626b\u7801\u6d3b\u52a8\u76f8\u5173\u7f16\u8f91\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            ScanActivityVo current = this.scanActivityVoService.update(dto);
            Result result = Result.ok((Object)current);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("scanActivityLockKey");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u626b\u7801\u6d3b\u52a8\u53c2\u4e0e\u5bf9\u8c61\u4e0b\u62c9")
    @GetMapping(value={"/findParticipateObjSelectList"})
    public Result<List<ScanActivityDictVo>> findParticipateObjSelectList() {
        try {
            return Result.ok((Object)this.scanActivityParticipateScopeVoService.findParticipateObjSelectList());
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

