/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityListVoRepository;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRepository;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ParticipateActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanParticipateStatusEnum;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityListVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanActivityListVoServiceImpl
implements ScanActivityListVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityListVoServiceImpl.class);
    @Autowired
    private ScanActivityListVoRepository scanActivityListVoRepository;
    @Autowired
    private ScanActivityUserScopeItemRepository scanActivityUserScopeItemRepository;
    @Autowired
    private ScanActivityRepository scanActivityRepository;

    public Page<ScanActivityListVo> findByConditions(Pageable pageable, ScanActivityListPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ScanActivityListPaginationDto());
        Validate.notBlank((CharSequence)paginationDto.getParticipateCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paginationDto.getParticipateObj(), (String)"\u53c2\u4e0e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ScanActivityListVo> pageResult = null;
        if (StringUtils.isBlank((CharSequence)paginationDto.getParticipateStatus())) {
            pageResult = this.scanActivityListVoRepository.findListByConditions((Page<ScanActivityListVo>)page, paginationDto);
        }
        if (ScanParticipateStatusEnum.DEFAULT.getDictCode().equals(paginationDto.getParticipateStatus())) {
            pageResult = this.scanActivityListVoRepository.findDefaultListByConditions((Page<ScanActivityListVo>)page, paginationDto);
        }
        if (ScanParticipateStatusEnum.PARTICIPATE.getDictCode().equals(paginationDto.getParticipateStatus())) {
            pageResult = this.scanActivityListVoRepository.findParticipateListByConditions((Page<ScanActivityListVo>)page, paginationDto);
        }
        if (ScanParticipateStatusEnum.OVERDUE.getDictCode().equals(paginationDto.getParticipateStatus())) {
            pageResult = this.scanActivityListVoRepository.findOverdueListByConditions((Page<ScanActivityListVo>)page, paginationDto);
        }
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageResult;
        }
        Set<String> actCodeSet = pageResult.getRecords().stream().map(ScanActivityListVo::getCode).collect(Collectors.toSet());
        List<ScanActivityUserScopeItem> list = this.scanActivityUserScopeItemRepository.findByParticipateObjAndUserCodeAndJoinFlagAndActCodeIn(paginationDto.getParticipateObj(), paginationDto.getParticipateCode(), Boolean.TRUE, actCodeSet);
        Map<Object, Object> map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(ScanActivityUserScopeItem::getActCode, Function.identity(), (a, b) -> b));
        }
        for (ScanActivityListVo item : pageResult.getRecords()) {
            ScanActivityUserScopeItem scopeItem = (ScanActivityUserScopeItem)((Object)map.get(item.getCode()));
            this.buildScanActivityListVo(scopeItem, item);
        }
        return pageResult;
    }

    @Transactional
    public void participateActivity(ParticipateActivityDto dto) {
        List<ScanActivityUserScopeItem> scopeItemList;
        Validate.notNull((Object)dto, (String)"\u53c2\u4e0e\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u53c2\u4e0e\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getParticipateCode(), (String)"\u53c2\u4e0e\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getParticipateObj(), (String)"\u53c2\u4e0e\u5bf9\u8c61\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ScanActivity> list = this.scanActivityRepository.findDetailsByCodes(Sets.newHashSet((Object[])new String[]{dto.getCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6d3b\u52a8\u4fe1\u606f", (Object[])new Object[0]);
        ScanActivity scanActivity = list.get(0);
        Validate.isTrue((boolean)dto.getParticipateObj().equals(scanActivity.getParticipateObj()), (String)"\u6d3b\u52a8\u53c2\u4e0e\u5bf9\u8c61\u7c7b\u578b\u4e8e\u8bf7\u6c42\u53c2\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        if (scanActivity.getParticipateScope().equals(ScanActivityScopeEnum.ALL.getDictCode()) && ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode().equals(scanActivity.getParticipateType())) {
            Validate.isTrue((boolean)false, (String)"\u60a8\u5df2\u81ea\u52a8\u53c2\u4e0e\u8be5\u6d3b\u52a8\uff0c\u8bf7\u52ff\u6267\u884c\u8be5\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        }
        Date now = new Date();
        if (ScanActivityParticipateTypeEnum.MANUAL.getDictCode().equals(scanActivity.getParticipateType())) {
            Validate.isTrue((scanActivity.getParticipateStartTime().compareTo(now) <= 0 ? 1 : 0) != 0, (String)"\u5c1a\u672a\u5230\u53c2\u4e0e\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u53c2\u4e0e\u8be5\u6d3b\u52a8!", (Object[])new Object[0]);
            Validate.isTrue((scanActivity.getParticipateEndTime().compareTo(now) > 0 ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u4e0d\u80fd\u53c2\u4e0e\u8be5\u6d3b\u52a8!", (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty(scopeItemList = this.scanActivityUserScopeItemRepository.findByParticipateObjAndUserCodeAndJoinFlagAndActCodeIn(dto.getParticipateObj(), dto.getParticipateCode(), null, Sets.newHashSet((Object[])new String[]{dto.getCode()})))) {
            Validate.isTrue((boolean)scanActivity.getParticipateScope().equals(ScanActivityScopeEnum.ALL.getDictCode()), (String)"\u5f53\u524d\u64cd\u4f5c\u4eba\u4e0d\u80fd\u53c2\u4e0e\u8be5\u6d3b\u52a8!", (Object[])new Object[0]);
            ScanActivityUserScopeItem scopeItem = new ScanActivityUserScopeItem();
            scopeItem.setCreateTime(now);
            scopeItem.setJoinFlag(Boolean.TRUE);
            scopeItem.setParticipateObj(dto.getParticipateObj());
            scopeItem.setUserCode(dto.getParticipateCode());
            scopeItem.setActCode(dto.getCode());
            this.scanActivityUserScopeItemRepository.save((Object)scopeItem);
        } else {
            ScanActivityUserScopeItem scopeItem = scopeItemList.get(0);
            Validate.isTrue((scopeItem.getJoinFlag() == false ? 1 : 0) != 0, (String)"\u60a8\u5df2\u53c2\u4e0e\u8be5\u6d3b\u52a8\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u8be5\u64cd\u4f5c\uff01", (Object[])new Object[0]);
            scopeItem.setCreateTime(now);
            scopeItem.setJoinFlag(Boolean.TRUE);
            this.scanActivityUserScopeItemRepository.saveOrUpdate((Object)scopeItem);
        }
    }

    public String findParticipateNumsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<ScanActivity> list = this.scanActivityRepository.findDetailsByCodes(Sets.newHashSet((Object[])new String[]{code}));
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6d3b\u52a8\u4fe1\u606f", (Object[])new Object[0]);
        ScanActivity scanActivity = list.get(0);
        if (ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode().equals(scanActivity.getParticipateType()) && ScanActivityScopeEnum.ALL.getDictCode().equals(scanActivity.getParticipateScope())) {
            return "\u5168\u90e8";
        }
        List<ScanActivityUserScopeItem> scopeItemList = this.scanActivityUserScopeItemRepository.findByParticipateObjAndUserCodeAndJoinFlagAndActCodeIn(scanActivity.getParticipateObj(), null, Boolean.TRUE, Sets.newHashSet((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(scopeItemList)) {
            return "0";
        }
        return String.valueOf(scopeItemList.size());
    }

    private void buildScanActivityListVo(ScanActivityUserScopeItem scopeItem, ScanActivityListVo item) {
        if (Objects.isNull(item)) {
            return;
        }
        if (ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode().equals(item.getParticipateType()) && ScanActivityScopeEnum.ALL.getDictCode().equals(item.getParticipateScope())) {
            item.setParticipateTime(item.getCreateTime());
            item.setParticipateStatus(ScanParticipateStatusEnum.PARTICIPATE.getDictCode());
            return;
        }
        if (Objects.nonNull((Object)scopeItem)) {
            item.setParticipateTime(scopeItem.getCreateTime());
            item.setParticipateStatus(ScanParticipateStatusEnum.PARTICIPATE.getDictCode());
            return;
        }
        item.setParticipateStatus(ScanParticipateStatusEnum.DEFAULT.getDictCode());
        if (item.getParticipateEndTime().compareTo(new Date()) < 0) {
            item.setParticipateStatus(ScanParticipateStatusEnum.OVERDUE.getDictCode());
        }
    }
}

