/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityParticipateScope;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityParticipateScopeRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityParticipateScopeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityParticipateScopeService")
public class ScanActivityParticipateScopeServiceImpl
implements ScanActivityParticipateScopeService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityParticipateScopeServiceImpl.class);
    @Autowired
    private ScanActivityParticipateScopeRepository scanActivityParticipateScopeRepository;

    @Override
    @Transactional
    public void createParticipateScope(String actCode, List<ScanActivityParticipateScope> list) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityParticipateScopeRepository.deleteByActCode(actCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int i = 0;
        HashSet set1 = Sets.newHashSet();
        for (ScanActivityParticipateScope item : list) {
            item.setActCode(actCode);
            item.setId("");
            item.setSort(i++);
            Validate.notBlank((CharSequence)item.getParticipateScopeType(), (String)"\u53c2\u4e0e\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getRelateCode(), (String)"\u5173\u8054\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)set1.add(StringUtils.join((Object[])new String[]{item.getParticipateScopeType(), "-", item.getRelateCode()})), (String)"\u5b58\u5728\u91cd\u590d\u7684\u8303\u56f4\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]);
        }
        this.scanActivityParticipateScopeRepository.saveBatch(list);
    }

    @Override
    public List<ScanActivityParticipateScope> findByActCode(String actCode) {
        if (StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        return this.scanActivityParticipateScopeRepository.findByActCodes(Sets.newHashSet((Object[])new String[]{actCode}));
    }
}

