/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityParticipateScope;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityParticipateScopeService;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityParticipateScopeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityParticipateScopeVoService")
public class ScanActivityParticipateScopeVoServiceImpl
implements ScanActivityParticipateScopeVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityParticipateScopeVoServiceImpl.class);
    @Autowired(required=false)
    private List<ScanActivityParticipateScopeRegister> registers;
    @Autowired
    private ScanActivityParticipateScopeService scanActivityParticipateScopeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<ScanActivityDictVo> findParticipateObjSelectList() {
        if (CollectionUtils.isEmpty(this.registers)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        this.registers.stream().sorted(Comparator.comparing(ScanActivityParticipateScopeRegister::sort)).forEach(a -> {
            ScanActivityDictVo cur = new ScanActivityDictVo();
            cur.setDictCode(a.getType());
            cur.setValue(a.getTypeDesc());
            re.add(cur);
        });
        return re;
    }

    @Transactional
    public void createParticipateScope(String actCode, String participateScope, List<ScanActivityParticipateScopeDto> list) {
        Validate.notBlank((CharSequence)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entityList = Lists.newLinkedList();
        if (!ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
            entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ScanActivityParticipateScopeDto.class, ScanActivityParticipateScope.class, HashSet.class, ArrayList.class, new String[0]);
        }
        this.scanActivityParticipateScopeService.createParticipateScope(actCode, entityList);
    }

    public List<ScanActivityParticipateScopeVo> findByParticipateObjAndActCode(String participateObj, String actCode) {
        if (StringUtils.isBlank((CharSequence)participateObj) || StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        List<ScanActivityParticipateScope> list = this.scanActivityParticipateScopeService.findByActCode(actCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List re = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ScanActivityParticipateScope.class, ScanActivityParticipateScopeVo.class, HashSet.class, ArrayList.class, new String[0]);
        String scopeType = list.get(0).getParticipateScopeType();
        if (!ScanActivityParticipateScopeTypeEnum.DEFAULT.getDictCode().equals(scopeType)) {
            return re;
        }
        Set userCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(ScanActivityParticipateScope::getRelateCode).collect(Collectors.toSet());
        Map map = this.getRegister(participateObj).findDataMapByCodes(userCodeSet);
        for (ScanActivityParticipateScopeVo item : re) {
            item.setData((JSONObject)map.get(item.getRelateCode()));
        }
        return re;
    }

    public Set<String> findScopeCodeSet(String participateObj, String participateScope, List<ScanActivityParticipateScopeDto> list) {
        return this.getRegister(participateObj).findScopeCodeSet(participateScope, list);
    }

    public Map<String, JSONObject> findDataMapByParticipateObjAndUserCodes(String participateObj, Set<String> userCodeSet) {
        HashMap re = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)participateObj) || CollectionUtils.isEmpty(userCodeSet)) {
            return re;
        }
        return this.getRegister(participateObj).findDataMapByCodes(userCodeSet);
    }

    private ScanActivityParticipateScopeRegister getRegister(String participateObj) {
        Validate.notBlank((CharSequence)participateObj, (String)"\u53c2\u4e0e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.registers) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7528\u7684\u53c2\u4e0e\u5bf9\u8c61\u7c7b\u578b\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        ScanActivityParticipateScopeRegister register = null;
        for (ScanActivityParticipateScopeRegister cur : this.registers) {
            if (!cur.getType().equals(participateObj)) continue;
            register = cur;
            break;
        }
        Validate.notNull(register, (String)"\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u53c2\u4e0e\u7c7b\u578b\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        return register;
    }
}

