/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityProductScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeItemService;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityProductScopeItemService")
public class ScanActivityProductScopeItemServiceImpl
implements ScanActivityProductScopeItemService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityProductScopeItemServiceImpl.class);
    @Autowired
    private ScanActivityProductScopeItemRepository scanActivityProductScopeItemRepository;

    @Override
    @Transactional
    public void createScopeItem(List<ScanActivityProductScopeItem> list, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(list)) {
            this.scanActivityProductScopeItemRepository.deleteByActCode(actCode);
            return;
        }
        Set curProductCodeSet = list.stream().map(ScanActivityProductScopeItem::getMaterialCode).collect(Collectors.toSet());
        List<ScanActivityProductScopeItem> oldList = this.scanActivityProductScopeItemRepository.findByActCodes(Sets.newHashSet((Object[])new String[]{actCode}));
        Set<Object> oldProductCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(oldList)) {
            oldProductCodeSet = oldList.stream().map(ScanActivityProductScopeItem::getMaterialCode).collect(Collectors.toSet());
        }
        HashSet delProductCodeSet = Sets.newHashSet();
        HashSet addProductCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(curProductCodeSet)) {
            delProductCodeSet = Sets.difference((Set)oldProductCodeSet, curProductCodeSet);
            addProductCodeSet = Sets.difference(curProductCodeSet, (Set)oldProductCodeSet);
        }
        if (!CollectionUtils.isEmpty((Collection)delProductCodeSet)) {
            HashSet finalDelProductCodeSet = delProductCodeSet;
            Set ids = oldList.stream().filter(a -> finalDelProductCodeSet.contains(a.getMaterialCode())).map(BaseIdEntity::getId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(ids)) {
                this.scanActivityProductScopeItemRepository.removeByIds(ids);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)addProductCodeSet)) {
            LinkedList addList = Lists.newLinkedList();
            for (String item : addProductCodeSet) {
                ScanActivityProductScopeItem cur = new ScanActivityProductScopeItem();
                cur.setActCode(actCode);
                cur.setMaterialCode(item);
                addList.add(cur);
            }
            this.scanActivityProductScopeItemRepository.saveBatch(addList);
        }
    }

    @Override
    @Transactional
    public void deleteByActCode(String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityProductScopeItemRepository.deleteByActCode(actCode);
    }

    @Override
    public Set<String> findProductScopeItemActCodeSet(Set<String> actCodeSet, Set<String> materialCodeSet) {
        if (CollectionUtils.isEmpty(actCodeSet) || CollectionUtils.isEmpty(materialCodeSet)) {
            return Sets.newHashSet();
        }
        HashSet set = Sets.newHashSet();
        for (List list : Lists.partition((List)Lists.newArrayList(materialCodeSet), (int)500)) {
            Set<String> cur = this.scanActivityProductScopeItemRepository.findProductScopeItemActCodeSet(actCodeSet, Sets.newHashSet((Iterable)list));
            if (CollectionUtils.isEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    @Override
    public Set<String> findMaterialActCodeSetByMaterialCodeAndActCodeIn(String materialCode, Set<String> actCodeSet) {
        if (StringUtils.isBlank((CharSequence)materialCode) || CollectionUtils.isEmpty(actCodeSet)) {
            return Sets.newHashSet();
        }
        return this.scanActivityProductScopeItemRepository.findProductScopeItemActCodeSet(actCodeSet, Sets.newHashSet((Object[])new String[]{materialCode}));
    }
}

