/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityProductScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeItemVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanActivityProductScopeItemVoServiceImpl
implements ScanActivityProductScopeItemVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityProductScopeItemVoServiceImpl.class);
    @Autowired
    private ScanActivityProductScopeItemRepository scanActivityProductScopeItemRepository;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<ScanActivityProductScopeItemVo> findByConditions(ScanActivityProductScopeItemPaginationDto dto) {
        List materialVoList;
        if (Objects.isNull(dto)) {
            return null;
        }
        dto.setPage(Optional.ofNullable(dto.getPage()).orElse(0));
        dto.setSize(Optional.ofNullable(dto.getSize()).orElse(50));
        if (StringUtils.isBlank((CharSequence)dto.getActCode())) {
            return null;
        }
        Page page = new Page((long)dto.getPage().intValue(), (long)dto.getSize().intValue());
        Page<ScanActivityProductScopeItem> pageResult = this.scanActivityProductScopeItemRepository.findByConditions((Page<ScanActivityProductScopeItem>)page, dto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return null;
        }
        Set materialCodeSet = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).map(ScanActivityProductScopeItem::getMaterialCode).collect(Collectors.toSet());
        Map<Object, Object> map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(materialCodeSet) && !CollectionUtils.isEmpty((Collection)(materialVoList = this.materialVoService.findDetailByMaterialCodes(materialCodeSet)))) {
            map = materialVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (a, b) -> a));
        }
        LinkedList list = Lists.newLinkedList();
        for (ScanActivityProductScopeItem item : pageResult.getRecords()) {
            ScanActivityProductScopeItemVo cur = new ScanActivityProductScopeItemVo();
            MaterialVo vo = (MaterialVo)map.get(item.getMaterialCode());
            if (Objects.nonNull(vo)) {
                cur = (ScanActivityProductScopeItemVo)this.nebulaToolkitService.copyObjectByBlankList((Object)vo, ScanActivityProductScopeItemVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            cur.setMaterialCode(item.getMaterialCode());
            list.add(cur);
        }
        Page re = new Page();
        re.setTotal(pageResult.getTotal());
        re.setSize(pageResult.getSize());
        re.setRecords((List)list);
        return re;
    }
}

