/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScope;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityProductScopeRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeService;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityProductScopeService")
public class ScanActivityProductScopeServiceImpl
implements ScanActivityProductScopeService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityProductScopeServiceImpl.class);
    @Autowired
    private ScanActivityProductScopeRepository scanActivityProductScopeRepository;

    @Override
    public List<ScanActivityProductScope> findByActCode(String actCode) {
        if (StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        return this.scanActivityProductScopeRepository.findByActCode(actCode);
    }

    @Override
    @Transactional
    public void createProductScope(List<ScanActivityProductScope> list, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7269\u6599\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityProductScopeRepository.deleteByActCode(actCode);
        int i = 0;
        for (ScanActivityProductScope item : list) {
            item.setActCode(actCode);
            item.setId("");
            item.setSort(i++);
        }
        this.scanActivityProductScopeRepository.saveBatch(list);
    }
}

