/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScope;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeService;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityProductScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityProductScopeRegister;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityProductScopeVoService")
public class ScanActivityProductScopeVoServiceImpl
implements ScanActivityProductScopeVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityProductScopeVoServiceImpl.class);
    @Autowired
    private ScanActivityProductScopeService scanActivityProductScopeService;
    @Autowired(required=false)
    private List<ScanActivityProductScopeRegister> productScopeRegisters;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private com.biz.crm.cps.business.product.sdk.service.MaterialVoService materialVoService1;
    @Autowired
    private MaterialVoService materialVoService;

    @Transactional
    public void createProductScope(List<ScanActivityProductScopeDto> list, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7269\u6599\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List scopes = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ScanActivityProductScopeDto.class, ScanActivityProductScope.class, HashSet.class, ArrayList.class, new String[0]);
        this.scanActivityProductScopeService.createProductScope(scopes, actCode);
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getScopeType(), a.getRelateCode()})).collect(Collectors.groupingBy(ScanActivityProductScopeDto::getScopeType, Collectors.mapping(ScanActivityProductScopeDto::getRelateCode, Collectors.toSet())));
        if (!map.isEmpty()) {
            for (Map.Entry item : map.entrySet()) {
                String dimensionFlag = item.getKey();
                CompletableFuture.runAsync(() -> this.materialVoService1.sync((List)Lists.newArrayList((Iterable)((Iterable)item.getValue())), dimensionFlag));
            }
        }
    }

    public List<ScanActivityProductScopeVo> findByActCode(String actCode) {
        List materialVoList;
        if (StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        List<ScanActivityProductScope> list = this.scanActivityProductScopeService.findByActCode(actCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List re = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ScanActivityProductScope.class, ScanActivityProductScopeVo.class, HashSet.class, ArrayList.class, new String[0]);
        String scopeType = list.get(0).getScopeType();
        if (!ScanActivityProductScopeTypeEnum.MATERIAL.getDictCode().equals(scopeType)) {
            return re;
        }
        Set materialCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(ScanActivityProductScope::getRelateCode).collect(Collectors.toSet());
        Map<Object, Object> map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(materialCodeSet) && !CollectionUtils.isEmpty((Collection)(materialVoList = this.materialVoService.findDetailByMaterialCodes(materialCodeSet)))) {
            map = materialVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (a, b) -> a));
        }
        for (ScanActivityProductScopeVo item : re) {
            MaterialVo cur = (MaterialVo)map.get(item.getRelateCode());
            if (!Objects.nonNull(cur)) continue;
            item.setData((JSONObject)JSONObject.toJSON((Object)cur));
        }
        return re;
    }

    public Set<String> findMaterialCodeSet(List<ScanActivityProductScopeDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Sets.newHashSet();
        }
        String scopeType = list.get(0).getScopeType();
        Set set = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(ScanActivityProductScopeDto::getRelateCode).collect(Collectors.toSet());
        return this.getRegister(scopeType).findByRelateCodeSet(set);
    }

    public List<ScanActivityDictVo> findProductScopeTypeList() {
        if (CollectionUtils.isEmpty(this.productScopeRegisters)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        this.productScopeRegisters.stream().sorted(Comparator.comparing(ScanActivityProductScopeRegister::sort)).forEach(a -> {
            ScanActivityDictVo cur = new ScanActivityDictVo();
            cur.setDictCode(a.getType());
            cur.setValue(a.getTypeDesc());
            if (!ScanActivityProductScopeTypeEnum.MATERIAL.getDictCode().equals(cur.getDictCode())) {
                re.add(cur);
            }
        });
        return re;
    }

    private ScanActivityProductScopeRegister getRegister(String scopeType) {
        Validate.notBlank((CharSequence)scopeType, (String)"\u7269\u6599\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.productScopeRegisters) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7528\u7684\u7269\u6599\u8303\u56f4\u7c7b\u578b\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        ScanActivityProductScopeRegister register = null;
        for (ScanActivityProductScopeRegister cur : this.productScopeRegisters) {
            if (!cur.getType().equals(scopeType)) continue;
            register = cur;
            break;
        }
        Validate.notNull(register, (String)"\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u7269\u6599\u8303\u56f4\u7c7b\u578b\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        return register;
    }
}

