/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRebate;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRebateValue;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityReward;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRewardValue;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRebateRepository;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRebateValueRepository;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRewardRepository;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRewardValueRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRebateDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRebateValueDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRewardDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRewardValueDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityRewardVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scanActivityRewardVoService")
public class ScanActivityRewardVoServiceImpl
implements ScanActivityRewardVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityRewardVoServiceImpl.class);
    @Autowired
    private ScanActivityRewardRepository scanActivityRewardRepository;
    @Autowired
    private ScanActivityRewardValueRepository scanActivityRewardValueRepository;
    @Autowired
    private ScanActivityRebateRepository scanActivityRebateRepository;
    @Autowired
    private ScanActivityRebateValueRepository scanActivityRebateValueRepository;
    @Autowired(required=false)
    private List<ScanActivityRewardRegister> rewardRegisters;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void createReward(List<ScanActivityRewardDto> rewardList, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(rewardList);
        this.scanActivityRewardRepository.deleteByActCode(actCode);
        this.scanActivityRewardValueRepository.deleteByActCode(actCode);
        this.scanActivityRebateRepository.deleteByActCode(actCode);
        this.scanActivityRebateValueRepository.deleteByActCode(actCode);
        List rewardCodeList = this.generateCodeService.generateCode("scanActivityRewardCode", rewardList.size());
        List rebateCodeList = Lists.newLinkedList();
        Integer rebateCount = 0;
        for (ScanActivityRewardDto item : rewardList) {
            if (!CollectionUtils.isNotEmpty((Collection)item.getRebateList())) continue;
            rebateCount = rebateCount + item.getRebateList().size();
        }
        if (rebateCount > 0) {
            rebateCodeList = this.generateCodeService.generateCode("scanActivityRebateCode", rebateCount.intValue());
        }
        LinkedList rewards = Lists.newLinkedList();
        LinkedList rewardValues = Lists.newLinkedList();
        LinkedList rebates = Lists.newLinkedList();
        LinkedList rebateValues = Lists.newLinkedList();
        this.initNeedSaveInfo(rewardList, actCode, rewards, rewardValues, rebates, rebateValues, rewardCodeList, rebateCodeList);
        if (CollectionUtils.isNotEmpty((Collection)rewards)) {
            this.scanActivityRewardRepository.saveBatch(rewards);
        }
        if (CollectionUtils.isNotEmpty((Collection)rewardValues)) {
            this.scanActivityRewardValueRepository.saveBatch(rewardValues);
        }
        if (CollectionUtils.isNotEmpty((Collection)rebates)) {
            this.scanActivityRebateRepository.saveBatch(rebates);
        }
        if (CollectionUtils.isNotEmpty((Collection)rebateValues)) {
            this.scanActivityRebateValueRepository.saveBatch(rebateValues);
        }
    }

    public List<ScanActivityRewardVo> findByActCode(String actCode) {
        if (StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        List<ScanActivityReward> rewards = this.scanActivityRewardRepository.findByActCode(actCode);
        if (CollectionUtils.isEmpty(rewards)) {
            return Lists.newLinkedList();
        }
        List<ScanActivityRewardValue> rewardValues = this.scanActivityRewardValueRepository.findByActCode(actCode);
        List<ScanActivityRebate> rebates = this.scanActivityRebateRepository.findByActCode(actCode);
        List<ScanActivityRebateValue> rebateValues = this.scanActivityRebateValueRepository.findByActCode(actCode);
        List rewardVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(rewards, ScanActivityReward.class, ScanActivityRewardVo.class, HashSet.class, ArrayList.class, new String[0]);
        List rewardValueVos = Lists.newLinkedList();
        List rebateVos = Lists.newLinkedList();
        List rebateValueVos = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(rewardValues)) {
            rewardValueVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(rewardValues, ScanActivityRewardValue.class, ScanActivityRewardValueVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (CollectionUtils.isNotEmpty(rebates)) {
            rebateVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(rebates, ScanActivityRebate.class, ScanActivityRebateVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (CollectionUtils.isNotEmpty(rebateValues)) {
            rebateValueVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(rebateValues, ScanActivityRebateValue.class, ScanActivityRebateValueVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return this.findRewards(rewardVos, rewardValueVos, rebateVos, rebateValueVos);
    }

    public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
        ScanActivityRewardScanTypeEnum rewardScanTypeEnum = ScanActivityRewardScanTypeEnum.findByBarCodeType((String)dto.getBarCodeType());
        if (Objects.isNull(rewardScanTypeEnum) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getBarCode(), dto.getProductCode(), dto.getScanParticipatorCode()}) || CollectionUtils.isEmpty(rewardList)) {
            return null;
        }
        ScanActivityParticipateObjEnum participateObj = ScanActivityParticipateObjEnum.findByTransformKey((String)dto.getParticipatorType());
        ScanActivityRewardRegister rewardRegister = this.findRewardRegister(participateObj);
        if (Objects.isNull(rewardRegister)) {
            return null;
        }
        return rewardRegister.findScanActivityRewardObserverVos(dto, rewardList);
    }

    private void initNeedSaveInfo(List<ScanActivityRewardDto> rewardList, String actCode, List<ScanActivityReward> rewards, List<ScanActivityRewardValue> rewardValues, List<ScanActivityRebate> rebates, List<ScanActivityRebateValue> rebateValues, List<String> rewardCodeList, List<String> rebateCodeList) {
        int c1 = 0;
        int c2 = 0;
        for (ScanActivityRewardDto item : rewardList) {
            ScanActivityReward reward = (ScanActivityReward)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)item, ScanActivityReward.class, HashSet.class, ArrayList.class, new String[0]));
            reward.setId("");
            reward.setActCode(actCode);
            reward.setRewardCode(rewardCodeList.get(c1++));
            reward.setSort(c1);
            rewards.add(reward);
            if (CollectionUtils.isNotEmpty((Collection)item.getValueList())) {
                int i = 1;
                for (ScanActivityRewardValueDto itemValue : item.getValueList()) {
                    ScanActivityRewardValue value = (ScanActivityRewardValue)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)itemValue, ScanActivityRewardValue.class, HashSet.class, ArrayList.class, new String[0]));
                    value.setId("");
                    value.setActCode(actCode);
                    value.setRewardCode(reward.getRewardCode());
                    value.setSort(i++);
                    rewardValues.add(value);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)item.getRebateList())) continue;
            for (ScanActivityRebateDto item1 : item.getRebateList()) {
                ScanActivityRebate rebate = (ScanActivityRebate)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)item1, ScanActivityRebate.class, HashSet.class, ArrayList.class, new String[0]));
                rebate.setId("");
                rebate.setActCode(actCode);
                rebate.setRebateCode(rebateCodeList.get(c2++));
                rebate.setRewardCode(reward.getRewardCode());
                rebate.setSort(c2);
                rebates.add(rebate);
                if (!CollectionUtils.isNotEmpty((Collection)item1.getValueList())) continue;
                int i = 1;
                for (ScanActivityRebateValueDto item1Value : item1.getValueList()) {
                    ScanActivityRebateValue value1 = (ScanActivityRebateValue)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)item1Value, ScanActivityRebateValue.class, HashSet.class, ArrayList.class, new String[0]));
                    value1.setId("");
                    value1.setActCode(actCode);
                    value1.setRebateCode(rebate.getRebateCode());
                    value1.setRebateValue(item1Value.getRebateValue());
                    value1.setSort(i++);
                    rebateValues.add(value1);
                }
            }
        }
    }

    private List<ScanActivityRewardVo> findRewards(List<ScanActivityRewardVo> rewardVos, List<ScanActivityRewardValueVo> rewardValueVos, List<ScanActivityRebateVo> rebateVos, List<ScanActivityRebateValueVo> rebateValueVos) {
        if (CollectionUtils.isEmpty(rewardVos)) {
            return Lists.newLinkedList();
        }
        Map<Object, Object> mapRewardValue = Maps.newHashMap();
        Map<Object, Object> mapRebate = Maps.newHashMap();
        Map<Object, Object> mapRebateValue = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(rewardValueVos)) {
            mapRewardValue = rewardValueVos.stream().collect(Collectors.groupingBy(ScanActivityRewardValueVo::getRewardCode));
        }
        if (CollectionUtils.isNotEmpty(rebateVos)) {
            mapRebate = rebateVos.stream().collect(Collectors.groupingBy(ScanActivityRebateVo::getRewardCode));
        }
        if (CollectionUtils.isNotEmpty(rebateValueVos)) {
            mapRebateValue = rebateValueVos.stream().collect(Collectors.groupingBy(ScanActivityRebateValueVo::getRebateCode));
        }
        for (ScanActivityRewardVo item : rewardVos) {
            item.setValueList((List)mapRewardValue.get(item.getRewardCode()));
            List rebateVoList = (List)mapRebate.get(item.getRewardCode());
            if (!CollectionUtils.isNotEmpty((Collection)rebateVoList)) continue;
            for (ScanActivityRebateVo rebateVo : rebateVoList) {
                rebateVo.setValueList((List)mapRebateValue.get(rebateVo.getRebateCode()));
            }
            item.setRebateList(rebateVoList);
        }
        return rewardVos;
    }

    private void validate(List<ScanActivityRewardDto> rewardList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(rewardList), (String)"\u626b\u7801\u6d3b\u52a8\u89c4\u5219\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet set1 = Sets.newHashSet();
        for (ScanActivityRewardDto item : rewardList) {
            Validate.isTrue((boolean)set1.add(StringUtils.join((Object[])new String[]{item.getType(), "-", item.getRewardType()})), (String)"\u6b63\u5411\u5956\u52b1\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)item.getValueList()), (String)"\u6b63\u5411\u5956\u52b1\u914d\u7f6e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (Boolean.FALSE.equals(item.getRandomFlag())) {
                Validate.isTrue((1 == item.getValueList().size() ? 1 : 0) != 0, (String)"\u6b63\u5411\u5956\u52b1\u56fa\u5b9a\u989d\u5ea6\u65f6\uff0c\u5bf9\u5e94\u7684\u660e\u7ec6\u914d\u7f6e\u9519\u8bef", (Object[])new Object[0]);
            }
            if (CollectionUtils.isEmpty((Collection)item.getRebateList())) continue;
            HashSet set2 = Sets.newHashSet();
            for (ScanActivityRebateDto sub : item.getRebateList()) {
                Validate.isTrue((boolean)set2.add(StringUtils.join((Object[])new String[]{sub.getObjType(), "-", sub.getRewardType()})), (String)"\u53cd\u5411\u5956\u52b1\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)sub.getValueList()), (String)"\u53cd\u5411\u5956\u52b1\u914d\u7f6e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!Boolean.FALSE.equals(sub.getRandomFlag())) continue;
                Validate.isTrue((1 == sub.getValueList().size() ? 1 : 0) != 0, (String)"\u53cd\u5411\u5956\u52b1\u56fa\u5b9a\u989d\u5ea6\u65f6\uff0c\u5bf9\u5e94\u7684\u660e\u7ec6\u914d\u7f6e\u9519\u8bef", (Object[])new Object[0]);
            }
        }
    }

    private ScanActivityRewardRegister findRewardRegister(ScanActivityParticipateObjEnum participateObj) {
        if (CollectionUtils.isEmpty(this.rewardRegisters) || Objects.isNull(participateObj)) {
            return null;
        }
        Optional<ScanActivityRewardRegister> first = this.rewardRegisters.stream().filter(a -> participateObj.getDictCode().equals(a.getKey())).findFirst();
        return first.orElse(null);
    }
}

