/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityParticipateScope;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.model.dto.ScanActivityCheckRepeatModelDto;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityParticipateScopeService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeItemService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserScopeItemService;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityStatusEnum;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityService")
public class ScanActivityServiceImpl
implements ScanActivityService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityServiceImpl.class);
    @Autowired
    private ScanActivityRepository scanActivityRepository;
    @Autowired
    private ScanActivityUserScopeItemService scanActivityUserScopeItemService;
    @Autowired
    private ScanActivityProductScopeItemService scanActivityProductScopeItemService;
    @Autowired
    private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;
    @Autowired
    private ScanActivityParticipateScopeService scanActivityParticipateScopeService;
    @Autowired
    private ScanActivityProductScopeVoService scanActivityProductScopeVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ScanActivity> findByConditions(Pageable pageable, ScanActivityPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ScanActivityPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ScanActivity> pageResult = this.scanActivityRepository.findByConditions((Page<ScanActivity>)page, dto);
        if (Objects.nonNull(pageResult) && !CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            for (ScanActivity item : pageResult.getRecords()) {
                item.setActStatus(this.findActStatus(item));
            }
        }
        return pageResult;
    }

    private String findActStatus(ScanActivity item) {
        if (Objects.isNull((Object)item) || Objects.isNull(item.getStartTime()) || Objects.isNull(item.getEndTime())) {
            return "";
        }
        Date now = new Date();
        if (now.compareTo(item.getStartTime()) < 0) {
            return ScanActivityStatusEnum.DEFAULT.getValue();
        }
        if (now.compareTo(item.getEndTime()) > 0) {
            return ScanActivityStatusEnum.FINISH.getValue();
        }
        return ScanActivityStatusEnum.RUNNING.getValue();
    }

    @Override
    public ScanActivity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ScanActivity)((Object)this.scanActivityRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<ScanActivity> findDetailByCodes(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return Lists.newLinkedList();
        }
        return this.scanActivityRepository.findDetailsByCodes(codeSet);
    }

    @Override
    @Transactional
    public ScanActivity create(ScanActivity scanActivity) {
        Validate.notNull((Object)((Object)scanActivity), (String)"\u626b\u7801\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityRepository.saveOrUpdate((Object)scanActivity);
        return scanActivity;
    }

    @Override
    @Transactional
    public ScanActivity update(ScanActivity scanActivity) {
        Validate.notNull((Object)((Object)scanActivity), (String)"\u626b\u7801\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)scanActivity.getId()), (String)"\u626b\u7801\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String currentId = scanActivity.getId();
        ScanActivity current = (ScanActivity)((Object)this.scanActivityRepository.getById((Serializable)((Object)currentId)));
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)scanActivity.getCode().equals(current.getCode()), (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.scanActivityRepository.saveOrUpdate((Object)scanActivity);
        return scanActivity;
    }

    @Override
    @Transactional
    public void enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ScanActivity activity = (ScanActivity)((Object)this.scanActivityRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)activity), (String)"\u626b\u7801\u6d3b\u52a8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!EnableStatusEnum.ENABLE.getCode().equals(activity.getEnableStatus()) ? 1 : 0) != 0, (String)"\u626b\u7801\u6d3b\u52a8\u5df2\u542f\u7528\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        activity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.handleEnableActivity(activity);
        this.scanActivityRepository.updateEnableStatusByIds(Lists.newArrayList((Object[])new String[]{id}), EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(String id) {
        Validate.notBlank((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ScanActivity activity = (ScanActivity)((Object)this.scanActivityRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)activity), (String)"\u626b\u7801\u6d3b\u52a8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!EnableStatusEnum.DISABLE.getCode().equals(activity.getEnableStatus()) ? 1 : 0) != 0, (String)"\u626b\u7801\u6d3b\u52a8\u5df2\u7981\u7528\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        this.scanActivityRepository.updateEnableStatusByIds(Lists.newArrayList((Object[])new String[]{id}), EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void handleEnableActivity(ScanActivity activity) {
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(activity.getEnableStatus()), (String)"\u626b\u7801\u6d3b\u52a8\u5df2\u542f\u7528\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        Boolean flag = ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode().equals(activity.getParticipateType());
        String participateScope = activity.getParticipateScope();
        Set<String> userCodeSet = this.findParticipateScopeCodeSet(activity, participateScope);
        Set<String> materialCodeSet = this.findMaterialCodeSet(activity);
        ScanActivityCheckRepeatModelDto repeatModelDto = new ScanActivityCheckRepeatModelDto();
        repeatModelDto.setActCode(activity.getCode());
        repeatModelDto.setActStartTime(activity.getStartTime());
        repeatModelDto.setActEndTime(activity.getEndTime());
        repeatModelDto.setParticipateObj(activity.getParticipateObj());
        repeatModelDto.setParticipateScope(activity.getParticipateScope());
        repeatModelDto.setUserCodeSet(userCodeSet);
        repeatModelDto.setMaterialCodeSet(materialCodeSet);
        this.validateRepeat(repeatModelDto);
        LinkedList productScopeItemList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(materialCodeSet)) {
            for (String item : materialCodeSet) {
                ScanActivityProductScopeItem cur = new ScanActivityProductScopeItem();
                cur.setActCode(activity.getCode());
                cur.setMaterialCode(item);
                productScopeItemList.add(cur);
            }
        }
        this.scanActivityProductScopeItemService.createScopeItem(productScopeItemList, activity.getCode());
        LinkedList userScopeItemList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(userCodeSet)) {
            Date now = new Date();
            for (String item : userCodeSet) {
                ScanActivityUserScopeItem cur = new ScanActivityUserScopeItem();
                cur.setActCode(activity.getCode());
                cur.setUserCode(item);
                cur.setParticipateObj(activity.getParticipateObj());
                cur.setJoinFlag(flag);
                if (Boolean.TRUE.equals(flag)) {
                    cur.setCreateTime(now);
                }
                userScopeItemList.add(cur);
            }
        }
        this.scanActivityUserScopeItemService.createScopeItem(userScopeItemList, activity.getCode());
    }

    @Override
    public void validateRepeat(ScanActivityCheckRepeatModelDto repeatModelDto) {
        Sets.SetView intersection1;
        if (Objects.isNull(repeatModelDto)) {
            Validate.isTrue((boolean)false, (String)"\u6d3b\u52a8\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty(repeatModelDto.getMaterialCodeSet()) || !ScanActivityScopeEnum.ALL.getDictCode().equals(repeatModelDto.getParticipateScope()) && CollectionUtils.isEmpty(repeatModelDto.getUserCodeSet())) {
            return;
        }
        List<ScanActivity> list = this.scanActivityRepository.findEnableRepeatByTimeBetweenAndParticipateObj(repeatModelDto.getActStartTime(), repeatModelDto.getActEndTime(), repeatModelDto.getParticipateObj());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet allActCodeSet = Sets.newHashSet();
        HashSet actCodeSet1 = Sets.newHashSet();
        HashSet actCodeSet2 = Sets.newHashSet();
        for (ScanActivity item : list) {
            if (repeatModelDto.getActCode().equals(item.getCode())) continue;
            allActCodeSet.add(item.getCode());
            if (ScanActivityScopeEnum.ALL.getDictCode().equals(item.getParticipateScope())) {
                actCodeSet1.add(item.getCode());
                continue;
            }
            actCodeSet2.add(item.getCode());
        }
        if (CollectionUtils.isEmpty((Collection)allActCodeSet)) {
            return;
        }
        Set<String> productScopeItemActCodeSet = this.scanActivityProductScopeItemService.findProductScopeItemActCodeSet(allActCodeSet, repeatModelDto.getMaterialCodeSet());
        productScopeItemActCodeSet = Optional.ofNullable(productScopeItemActCodeSet).orElse(Sets.newHashSet());
        if (ScanActivityScopeEnum.ALL.getDictCode().equals(repeatModelDto.getParticipateScope())) {
            if (!CollectionUtils.isEmpty(productScopeItemActCodeSet)) {
                Validate.isTrue((boolean)false, (String)("\u5f53\u524d\u6d3b\u52a8\u4e0e" + StringUtils.join(productScopeItemActCodeSet, (String)",") + "\u6d3b\u52a8\u7f16\u7801\u5bf9\u5e94\u7684\u53c2\u4e0e\u4fe1\u606f\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
            } else {
                return;
            }
        }
        if (!(intersection1 = Sets.intersection((Set)actCodeSet1, productScopeItemActCodeSet)).isEmpty()) {
            Validate.isTrue((boolean)false, (String)("\u5f53\u524d\u6d3b\u52a8\u4e0e" + StringUtils.join((Iterable)intersection1, (String)",") + "\u6d3b\u52a8\u7f16\u7801\u5bf9\u5e94\u7684\u53c2\u4e0e\u4fe1\u606f\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty((Collection)actCodeSet2)) {
            return;
        }
        Set<String> userScopeItemActCodeSet = this.scanActivityUserScopeItemService.findUserScopeItemActCodeSet(repeatModelDto.getParticipateObj(), actCodeSet2, repeatModelDto.getUserCodeSet());
        Sets.SetView intersection2 = Sets.intersection(userScopeItemActCodeSet, productScopeItemActCodeSet);
        if (!intersection2.isEmpty()) {
            Validate.isTrue((boolean)false, (String)("\u5f53\u524d\u6d3b\u52a8\u4e0e" + StringUtils.join((Iterable)intersection2, (String)",") + "\u6d3b\u52a8\u7f16\u7801\u5bf9\u5e94\u7684\u53c2\u4e0e\u4fe1\u606f\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
        }
    }

    private Set<String> findParticipateScopeCodeSet(ScanActivity activity, String participateScope) {
        HashSet codeSet = Sets.newHashSet();
        if (ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
            return codeSet;
        }
        List<ScanActivityParticipateScope> participateScopeList = this.scanActivityParticipateScopeService.findByActCode(activity.getCode());
        List dtoList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(participateScopeList)) {
            dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(participateScopeList, ScanActivityParticipateScope.class, ScanActivityParticipateScopeDto.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return this.scanActivityParticipateScopeVoService.findScopeCodeSet(activity.getParticipateObj(), activity.getParticipateScope(), dtoList);
    }

    private Set<String> findMaterialCodeSet(ScanActivity activity) {
        List productScopeVoList = this.scanActivityProductScopeVoService.findByActCode(activity.getCode());
        List scopeList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty((Collection)productScopeVoList)) {
            scopeList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)productScopeVoList, ScanActivityProductScopeVo.class, ScanActivityProductScopeDto.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return this.scanActivityProductScopeVoService.findMaterialCodeSet(scopeList);
    }
}

