/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserArea;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserAreaRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserAreaService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanActivityUserAreaServiceImpl
implements ScanActivityUserAreaService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityUserAreaServiceImpl.class);
    @Autowired
    private ScanActivityUserAreaRepository scanActivityUserAreaRepository;

    @Override
    @Transactional
    public void createArea(List<ScanActivityUserArea> areaList, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityUserAreaRepository.deleteByActCode(actCode);
        if (CollectionUtils.isEmpty(areaList)) {
            return;
        }
        int i = 0;
        for (ScanActivityUserArea item : areaList) {
            item.setActCode(actCode);
            item.setSort(i++);
        }
        this.scanActivityUserAreaRepository.saveBatch(areaList);
    }

    @Override
    public List<ScanActivityUserArea> findByActCode(String actCode) {
        if (StringUtils.isBlank((CharSequence)actCode)) {
            return Lists.newLinkedList();
        }
        return this.scanActivityUserAreaRepository.findByActCode(actCode);
    }

    @Override
    public Set<String> findAreaActCodeSetByAreaAndActCodeIn(String provinceName, String cityName, Set<String> actCodeSet) {
        if (CollectionUtils.isEmpty(actCodeSet)) {
            return Sets.newHashSet();
        }
        provinceName = Optional.ofNullable(provinceName).orElse("");
        cityName = Optional.ofNullable(cityName).orElse("");
        return this.scanActivityUserAreaRepository.findAreaActCodeSetByAreaAndActCodeIn(provinceName, cityName, actCodeSet);
    }
}

