/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserScopeItemService;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityUserScopeItemService")
public class ScanActivityUserScopeItemServiceImpl
implements ScanActivityUserScopeItemService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityUserScopeItemServiceImpl.class);
    @Autowired
    private ScanActivityUserScopeItemRepository scanActivityUserScopeItemRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void deleteByActCode(String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scanActivityUserScopeItemRepository.deleteByActCode(actCode);
    }

    @Override
    @Transactional
    public void createScopeItem(List<ScanActivityUserScopeItem> list, String actCode) {
        Validate.notBlank((CharSequence)actCode, (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(list)) {
            this.scanActivityUserScopeItemRepository.deleteByActCode(actCode);
            return;
        }
        ScanActivityUserScopeItem first = list.get(0);
        String participateObj = first.getParticipateObj();
        Boolean joinFlag = first.getJoinFlag();
        Date createTime = first.getCreateTime();
        Set curUserCodeSet = list.stream().map(ScanActivityUserScopeItem::getUserCode).collect(Collectors.toSet());
        List<ScanActivityUserScopeItem> oldList = this.scanActivityUserScopeItemRepository.findByActCodes(Sets.newHashSet((Object[])new String[]{actCode}));
        Set<Object> oldUserCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(oldList)) {
            oldUserCodeSet = oldList.stream().map(ScanActivityUserScopeItem::getUserCode).collect(Collectors.toSet());
        }
        HashSet delUserCodeSet = Sets.newHashSet();
        HashSet addUserCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(curUserCodeSet)) {
            delUserCodeSet = Sets.difference((Set)oldUserCodeSet, curUserCodeSet);
            addUserCodeSet = Sets.difference(curUserCodeSet, (Set)oldUserCodeSet);
        }
        if (!CollectionUtils.isEmpty((Collection)delUserCodeSet)) {
            HashSet finalDelUserCodeSet = delUserCodeSet;
            Set ids = oldList.stream().filter(a -> finalDelUserCodeSet.contains(a.getUserCode())).map(BaseIdEntity::getId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(ids)) {
                this.scanActivityUserScopeItemRepository.removeByIds(ids);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)addUserCodeSet)) {
            LinkedList addList = Lists.newLinkedList();
            for (String item : addUserCodeSet) {
                ScanActivityUserScopeItem cur = new ScanActivityUserScopeItem();
                cur.setActCode(actCode);
                cur.setUserCode(item);
                cur.setParticipateObj(participateObj);
                cur.setJoinFlag(joinFlag);
                cur.setCreateTime(createTime);
                addList.add(cur);
            }
            this.scanActivityUserScopeItemRepository.saveBatch(addList);
        }
    }

    @Override
    public Set<String> findUserScopeItemActCodeSet(String participateObj, Set<String> actCodeSet, Set<String> userCodeSet) {
        if (StringUtils.isBlank((CharSequence)participateObj) || CollectionUtils.isEmpty(actCodeSet) || CollectionUtils.isEmpty(userCodeSet)) {
            return Sets.newHashSet();
        }
        HashSet set = Sets.newHashSet();
        for (List list : Lists.partition((List)Lists.newArrayList(userCodeSet), (int)500)) {
            Set<String> cur = this.scanActivityUserScopeItemRepository.findUserScopeItemActCodeSet(participateObj, actCodeSet, Sets.newHashSet((Iterable)list));
            if (CollectionUtils.isEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    @Override
    public Set<String> findCurExecActCodeSetByParticipateObjAndUserCode(String participateObj, String userCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{participateObj, userCode})) {
            return Sets.newHashSet();
        }
        return this.scanActivityUserScopeItemRepository.findCurExecActCodeSetByParticipateObjAndUserCode(participateObj, userCode);
    }
}

