/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityUserScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityUserScopeItemVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanActivityUserScopeItemVoServiceImpl
implements ScanActivityUserScopeItemVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityUserScopeItemVoServiceImpl.class);
    @Autowired
    private ScanActivityUserScopeItemRepository scanActivityUserScopeItemRepository;
    @Autowired
    private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;

    public Page<ScanActivityUserScopeItemVo> findByConditions(ScanActivityUserScopeItemPaginationDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        dto.setPage(Optional.ofNullable(dto.getPage()).orElse(0));
        dto.setSize(Optional.ofNullable(dto.getSize()).orElse(50));
        if (StringUtils.isBlank((CharSequence)dto.getActCode()) || StringUtils.isBlank((CharSequence)dto.getParticipateObj())) {
            return null;
        }
        Page page = new Page((long)dto.getPage().intValue(), (long)dto.getSize().intValue());
        Page<ScanActivityUserScopeItem> pageResult = this.scanActivityUserScopeItemRepository.findByConditions((Page<ScanActivityUserScopeItem>)page, dto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return null;
        }
        Set userCodeSet = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(ScanActivityUserScopeItem::getUserCode).collect(Collectors.toSet());
        Map map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(userCodeSet)) {
            map = this.scanActivityParticipateScopeVoService.findDataMapByParticipateObjAndUserCodes(dto.getParticipateObj(), userCodeSet);
        }
        LinkedList list = Lists.newLinkedList();
        for (ScanActivityUserScopeItem item : pageResult.getRecords()) {
            ScanActivityUserScopeItemVo cur = new ScanActivityUserScopeItemVo();
            cur.setData((JSONObject)map.get(item.getUserCode()));
            list.add(cur);
        }
        Page re = new Page();
        re.setTotal(pageResult.getTotal());
        re.setSize(pageResult.getSize());
        re.setRecords((List)list);
        return re;
    }
}

