/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserArea;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.model.dto.ScanActivityCheckRepeatModelDto;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeItemService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserAreaService;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserScopeItemService;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityQueryDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRebateDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityRewardDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityShareProfitDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserAreaDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityRewardVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardAccountVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityUserAreaVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="scanActivityVoService")
public class ScanActivityVoServiceImpl
implements ScanActivityVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityVoServiceImpl.class);
    @Autowired
    private ScanActivityService scanActivityService;
    @Autowired
    private ScanActivityRewardVoService scanActivityRewardVoService;
    @Autowired
    private ScanActivityProductScopeVoService scanActivityProductScopeVoService;
    @Autowired
    private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;
    @Autowired
    private ScanActivityUserScopeItemService scanActivityUserScopeItemService;
    @Autowired
    private ScanActivityProductScopeItemService scanActivityProductScopeItemService;
    @Autowired
    private TaxRaiseCapitalAccountVoService taxRaiseCapitalAccountVoService;
    @Autowired
    private ScanActivityUserAreaService scanActivityUserAreaService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public ScanActivityVo findDetailById(String id) {
        TaxRaiseCapitalAccountVo taxRaiseCapitalAccountVo;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ScanActivityVo vo = this.findById(id);
        List participateScopeVoList = this.scanActivityParticipateScopeVoService.findByParticipateObjAndActCode(vo.getParticipateObj(), vo.getCode());
        List productScopeVoList = this.scanActivityProductScopeVoService.findByActCode(vo.getCode());
        List rewardVoList = this.scanActivityRewardVoService.findByActCode(vo.getCode());
        List areaVoList = Lists.newLinkedList();
        List<ScanActivityUserArea> areaList = this.scanActivityUserAreaService.findByActCode(vo.getCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(areaList)) {
            areaVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(areaList, ScanActivityUserArea.class, ScanActivityUserAreaVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getAccountCode()) && Objects.nonNull(taxRaiseCapitalAccountVo = this.taxRaiseCapitalAccountVoService.findByMerchantUserAccount(vo.getAccountCode()))) {
            ScanActivityRewardAccountVo accountVo = new ScanActivityRewardAccountVo();
            accountVo.setAccountCode(taxRaiseCapitalAccountVo.getAccountCode());
            accountVo.setAccountName(taxRaiseCapitalAccountVo.getAccountName());
            accountVo.setAmount(taxRaiseCapitalAccountVo.getAmount());
            vo.setAccount(accountVo);
        }
        vo.setParticipateScopeList(participateScopeVoList);
        vo.setProductList(productScopeVoList);
        vo.setRewardList(rewardVoList);
        vo.setAreaList(areaVoList);
        return vo;
    }

    public ScanActivityVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ScanActivity scanActivity = this.scanActivityService.findDetailById(id);
        if (Objects.isNull((Object)scanActivity)) {
            return null;
        }
        return (ScanActivityVo)this.nebulaToolkitService.copyObjectByBlankList((Object)scanActivity, ScanActivityVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public ScanActivityVo create(ScanActivityDto dto) {
        Validate.notNull((Object)dto, (String)"\u626b\u7801\u6d3b\u52a8\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setCode((String)this.generateCodeService.generateCode("scanActivityCode", 1).get(0));
        this.validate(dto);
        this.scanActivityService.create((ScanActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ScanActivity.class, HashSet.class, ArrayList.class, new String[0])));
        this.saveScanActivityExtInfo(dto);
        return null;
    }

    @Transactional
    public ScanActivityVo update(ScanActivityDto dto) {
        Validate.notNull((Object)dto, (String)"\u626b\u7801\u6d3b\u52a8\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(dto);
        this.scanActivityService.update((ScanActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ScanActivity.class, HashSet.class, ArrayList.class, new String[0])));
        this.saveScanActivityExtInfo(dto);
        return null;
    }

    public String findActCodeByScanActivityQueryDto(ScanActivityQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getParticipateObj(), dto.getUserCode(), dto.getMaterialCode()})) {
            return "";
        }
        Set<String> actCodeSet = this.scanActivityUserScopeItemService.findCurExecActCodeSetByParticipateObjAndUserCode(dto.getParticipateObj(), dto.getUserCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(actCodeSet)) {
            return "";
        }
        Set<String> diffActCodeSet = this.scanActivityProductScopeItemService.findMaterialActCodeSetByMaterialCodeAndActCodeIn(dto.getMaterialCode(), actCodeSet);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(diffActCodeSet)) {
            return "";
        }
        if (!dto.getParticipateObj().equals(ScanActivityParticipateObjEnum.USER.getDictCode())) {
            Optional first = diffActCodeSet.stream().findFirst();
            return first.orElse("");
        }
        Set<String> diffActCodeSet1 = this.scanActivityUserAreaService.findAreaActCodeSetByAreaAndActCodeIn(dto.getProvinceName(), dto.getCityName(), diffActCodeSet);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(diffActCodeSet1)) {
            return "";
        }
        Optional first = diffActCodeSet1.stream().findFirst();
        return first.orElse("");
    }

    public List<ScanActivityVo> findMainByActCodes(Set<String> actCodeSet) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(actCodeSet)) {
            return Lists.newLinkedList();
        }
        List<ScanActivity> list = this.scanActivityService.findDetailByCodes(actCodeSet);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ScanActivity.class, ScanActivityVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void saveScanActivityExtInfo(ScanActivityDto dto) {
        this.scanActivityParticipateScopeVoService.createParticipateScope(dto.getCode(), dto.getParticipateScope(), dto.getParticipateScopeList());
        this.scanActivityProductScopeVoService.createProductScope(dto.getProductList(), dto.getCode());
        this.scanActivityRewardVoService.createReward(dto.getRewardList(), dto.getCode());
        List areaList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAreaList())) {
            areaList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getAreaList(), ScanActivityUserAreaDto.class, ScanActivityUserArea.class, HashSet.class, ArrayList.class, new String[0]);
        }
        this.scanActivityUserAreaService.createArea(areaList, dto.getCode());
        if (!EnableStatusEnum.ENABLE.getCode().equals(dto.getEnableStatus())) {
            return;
        }
        this.handleEnableActivity(dto);
    }

    @Transactional
    public void handleEnableActivity(ScanActivityDto dto) {
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(dto.getEnableStatus()), (String)"\u626b\u7801\u6d3b\u52a8\u5df2\u542f\u7528\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        Boolean flag = ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode().equals(dto.getParticipateType());
        String participateScope = dto.getParticipateScope();
        Set userCodeSet = Sets.newHashSet();
        if (!ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
            userCodeSet = this.scanActivityParticipateScopeVoService.findScopeCodeSet(dto.getParticipateObj(), dto.getParticipateScope(), dto.getParticipateScopeList());
        }
        Set materialCodeSet = this.scanActivityProductScopeVoService.findMaterialCodeSet(dto.getProductList());
        ScanActivityCheckRepeatModelDto repeatModelDto = new ScanActivityCheckRepeatModelDto();
        repeatModelDto.setActCode(dto.getCode());
        repeatModelDto.setActStartTime(dto.getStartTime());
        repeatModelDto.setActEndTime(dto.getEndTime());
        repeatModelDto.setParticipateObj(dto.getParticipateObj());
        repeatModelDto.setParticipateScope(dto.getParticipateScope());
        repeatModelDto.setUserCodeSet(userCodeSet);
        repeatModelDto.setMaterialCodeSet(materialCodeSet);
        this.scanActivityService.validateRepeat(repeatModelDto);
        LinkedList productScopeItemList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty((Collection)materialCodeSet)) {
            for (String item : materialCodeSet) {
                ScanActivityProductScopeItem cur = new ScanActivityProductScopeItem();
                cur.setActCode(dto.getCode());
                cur.setMaterialCode(item);
                productScopeItemList.add(cur);
            }
        }
        this.scanActivityProductScopeItemService.createScopeItem(productScopeItemList, dto.getCode());
        LinkedList userScopeItemList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty((Collection)userCodeSet)) {
            Date now = new Date();
            for (String item : userCodeSet) {
                ScanActivityUserScopeItem cur = new ScanActivityUserScopeItem();
                cur.setActCode(dto.getCode());
                cur.setUserCode(item);
                cur.setParticipateObj(dto.getParticipateObj());
                cur.setJoinFlag(flag);
                if (Boolean.TRUE.equals(flag)) {
                    cur.setCreateTime(now);
                }
                userScopeItemList.add(cur);
            }
        }
        this.scanActivityUserScopeItemService.createScopeItem(userScopeItemList, dto.getCode());
    }

    private void validate(ScanActivityDto dto) {
        Validate.notBlank((CharSequence)dto.getParticipateObj(), (String)"\u53c2\u4e0e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u626b\u7801\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getStartTime()) && Objects.nonNull(dto.getEndTime()) && dto.getEndTime().compareTo(dto.getStartTime()) > 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipateScope(), (String)"\u53c2\u4e0e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductScope(), (String)"\u7269\u6599\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!dto.getParticipateScope().equals(ScanActivityScopeEnum.ALL.getDictCode())) {
            Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getProductList()), (String)"\u7269\u6599\u8303\u56f4\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getRewardList()), (String)"\u6d3b\u52a8\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getParticipateType(), (String)"\u53c2\u4e0e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ScanActivityParticipateTypeEnum.MANUAL.getDictCode().equals(dto.getParticipateType())) {
            Validate.isTrue((Objects.nonNull(dto.getParticipateStartTime()) && Objects.nonNull(dto.getParticipateEndTime()) && dto.getParticipateEndTime().compareTo(dto.getParticipateStartTime()) > 0 ? 1 : 0) != 0, (String)"\u626b\u7801\u6d3b\u52a8\u53c2\u4e0e\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        }
        Boolean f1 = false;
        block0: for (ScanActivityRewardDto item : dto.getRewardList()) {
            if (ScanActivityRewardTypeEnum.RED_PACKET.getDictCode().equals(item.getRewardType())) {
                f1 = true;
                break;
            }
            if (!CollectionUtil.isNotEmpty((Collection)item.getRebateList())) continue;
            for (ScanActivityRebateDto sub : item.getRebateList()) {
                if (!ScanActivityRewardTypeEnum.RED_PACKET.getDictCode().equals(sub.getRewardType())) continue;
                f1 = true;
                continue block0;
            }
        }
        if (Boolean.TRUE.equals(f1)) {
            Validate.isTrue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getAccountCode()}) && Objects.nonNull(dto.getAccount()) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u53d1\u653e\u7ea2\u5305\u7684\u5145\u503c\u8d26\u6237", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getAccountCode()), (String)"\u65e0\u9700\u6dfb\u52a0\u5145\u503c\u8d26\u6237", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dto.getEnableStatus(), (String)"\u542f\u7528/\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (EnableStatusEnum.ENABLE.getCode().equals(dto.getEnableStatus()) && Boolean.TRUE.equals(f1)) {
            Validate.isTrue((Optional.ofNullable(dto.getAccount().getAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6240\u9009\u7ea2\u5305\u653e\u53d1\u8d26\u6237\u53ef\u7528\u4f59\u989d\u9700\u5927\u4e8e0", (Object[])new Object[0]);
        }
        if (ScanActivityParticipateObjEnum.USER.getDictCode().equals(dto.getParticipateObj()) && Boolean.TRUE.equals(dto.getAreaFlag())) {
            Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAreaList()), (String)"\u8bf7\u914d\u7f6e\u626b\u7801\u533a\u57df\u9650\u5236\u4fe1\u606f", (Object[])new Object[0]);
            HashSet set = Sets.newHashSet();
            for (ScanActivityUserAreaDto item : dto.getAreaList()) {
                Validate.notBlank((CharSequence)item.getProvinceCode(), (String)"\u8bf7\u9009\u62e9\u7701\u4efd\u4fe1\u606f", (Object[])new Object[0]);
                boolean f = set.add(StringUtils.join((Object[])new String[]{item.getProvinceCode(), "-", Optional.ofNullable(item.getActCode()).orElse("")}));
                Validate.isTrue((boolean)f, (String)"\u5b58\u5728\u91cd\u590d\u7684\u533a\u57df\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
            }
        }
    }

    private void shareProfitValidate(ScanActivityShareProfitDto dto) {
        Validate.notNull((Object)dto, (String)"\u5206\u5229\u53c2\u6570\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getBarCode(), dto.getBarCodeType(), dto.getActCode(), dto.getParticipateObj(), dto.getProductCode(), dto.getUserCode()}), (String)"\u5206\u5229\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
    }
}

