/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.notifier;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityRewardVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.observer.ScanActivityRewardObserver;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ScanActivityScanCodeRecordEventListenerImpl
implements ScanCodeRecordEventListener {
    @Autowired
    private ScanActivityRewardVoService scanActivityRewardVoService;
    @Autowired
    private ScanActivityVoService scanActivityVoService;
    @Autowired(required=false)
    private List<ScanActivityRewardObserver> observers;

    @Transactional
    public void onSuccessScan(ScanCodeRecordEventDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getScanActCode())) {
            return;
        }
        List activityVoList = this.scanActivityVoService.findMainByActCodes((Set)Sets.newHashSet((Object[])new String[]{dto.getScanActCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityVoList) ? 1 : 0) != 0, (String)StringUtils.join((Object[])new String[]{dto.getScanActCode(), "\u626b\u7801\u6d3b\u52a8\u4e0d\u5b58\u5728"}), (Object[])new Object[0]);
        ScanActivityVo scanActivityVo = (ScanActivityVo)activityVoList.get(0);
        dto.setAccountCode(scanActivityVo.getAccountCode());
        List rewardVoList = this.scanActivityRewardVoService.findByActCode(dto.getScanActCode());
        if (CollectionUtils.isEmpty((Collection)rewardVoList)) {
            return;
        }
        List<ScanActivityRewardObserverVo> data = this.findScanActivityRewardObserverVos(dto, rewardVoList);
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        for (ScanActivityRewardObserver observer : this.observers) {
            observer.createRewardRecord(data);
        }
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }

    private List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardVoList) {
        String barCode = dto.getBarCode();
        ScanActivityRewardScanTypeEnum rewardScanTypeEnum = ScanActivityRewardScanTypeEnum.findByTransformKey((String)dto.getBarCodeType());
        String materialCode = dto.getProductCode();
        String userCode = dto.getScanParticipatorCode();
        ScanActivityParticipateObjEnum participateObjEnum = ScanActivityParticipateObjEnum.findByTransformKey((String)dto.getParticipatorType());
        return this.scanActivityRewardVoService.findScanActivityRewardObserverVos(dto, rewardVoList);
    }
}

