/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.vo.RewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerScanActivityRewardRegisterImpl
implements ScanActivityRewardRegister {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private DealerVoService dealerVoService;

    public String getKey() {
        return ScanActivityParticipateObjEnum.CUSTOMER.getDictCode();
    }

    public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
        LinkedList list = Lists.newLinkedList();
        ScanActivityRewardScanTypeEnum rewardScanTypeEnum = ScanActivityRewardScanTypeEnum.findByBarCodeType((String)dto.getBarCodeType());
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u4eba\u4fe1\u606f", (Object[])new Object[0]);
        String consumerName = loginUser.getConsumerName();
        String customerCode = dto.getScanParticipatorCode();
        DealerVo dealerVo = this.dealerVoService.findByCustomerCode(customerCode);
        Validate.notNull((Object)dealerVo, (String)"\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        for (ScanActivityRewardVo item : rewardList) {
            if (!rewardScanTypeEnum.getDictCode().equals(item.getType())) continue;
            ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
            cur.setScanActCode(dto.getScanActCode());
            cur.setAccountCode(dto.getAccountCode());
            cur.setMaterialCode(dto.getProductCode());
            cur.setTriggerAction(StringUtils.join((Object[])new String[]{"\u626b", rewardScanTypeEnum.getValue()}));
            cur.setRecordCode(dto.getRecordCode());
            ScanActivityRewardTypeEnum rewardTypeEnum = ScanActivityRewardTypeEnum.findByDictCode((String)item.getRewardType());
            if (Objects.isNull(rewardTypeEnum)) continue;
            cur.setRewardType(rewardTypeEnum.getTransformKey());
            cur.setParticipateObj(ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
            cur.setUserCode(dto.getScanParticipatorCode());
            cur.setName(consumerName);
            cur.setRandomFlag(item.getRandomFlag());
            cur.setChannel(dealerVo.getChannelCode());
            cur.setOrgCode(dealerVo.getOrgCode());
            cur.setOrgName(dealerVo.getOrgName());
            cur.setValueList(this.findRewardValueList(item.getValueList()));
            list.add(cur);
        }
        return list;
    }

    private List<RewardValueVo> findRewardValueList(List<ScanActivityRewardValueVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        for (ScanActivityRewardValueVo item : list) {
            RewardValueVo cur = new RewardValueVo();
            cur.setPercent(item.getRate());
            cur.setCash(item.getRewardValue());
            re.add(cur);
        }
        return re;
    }
}

