/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRebateObjTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.vo.RewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanBarCodeRecordFindDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TerminalScanActivityRewardRegisterImpl
implements ScanActivityRewardRegister {
    @Autowired
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private DealerVoService dealerVoService;
    @Autowired
    private TerminalVoService terminalVoService;

    public String getKey() {
        return ScanActivityParticipateObjEnum.TERMINAL.getDictCode();
    }

    public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
        LinkedList list = Lists.newLinkedList();
        ScanActivityRewardScanTypeEnum rewardScanTypeEnum = ScanActivityRewardScanTypeEnum.findByBarCodeType((String)dto.getBarCodeType());
        List curRewardList = rewardList.stream().filter(a -> rewardScanTypeEnum.getDictCode().equals(a.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(curRewardList)) {
            return list;
        }
        Boolean flag = Boolean.FALSE;
        block0: for (ScanActivityRewardVo item : curRewardList) {
            List rebateList = item.getRebateList();
            if (CollectionUtils.isEmpty((Collection)rebateList)) continue;
            for (ScanActivityRebateVo sub : rebateList) {
                if (!ScanActivityRebateObjTypeEnum.CUSTOMER.getDictCode().equals(sub.getObjType())) continue;
                flag = true;
                continue block0;
            }
        }
        String customerCode = this.findRebateCustomerCode(flag, dto.getScanParticipatorCode(), dto.getBarCode(), rewardScanTypeEnum.getBarCodeType(), dto.getProductCode());
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u4eba\u4fe1\u606f", (Object[])new Object[0]);
        String consumerName = loginUser.getConsumerName();
        String terminalCode = dto.getScanParticipatorCode();
        List terminalVoList = this.terminalVoService.findByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{terminalCode}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)terminalVoList) ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        TerminalVo terminalVo = (TerminalVo)terminalVoList.stream().findFirst().get();
        for (ScanActivityRewardVo item : curRewardList) {
            ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
            cur.setScanActCode(dto.getScanActCode());
            cur.setAccountCode(dto.getAccountCode());
            cur.setMaterialCode(dto.getProductCode());
            cur.setTriggerAction(StringUtils.join((Object[])new String[]{"\u626b", rewardScanTypeEnum.getValue()}));
            cur.setRecordCode(dto.getRecordCode());
            ScanActivityRewardTypeEnum rewardTypeEnum = ScanActivityRewardTypeEnum.findByDictCode((String)item.getRewardType());
            if (Objects.isNull(rewardTypeEnum)) continue;
            cur.setRewardType(rewardTypeEnum.getTransformKey());
            cur.setParticipateObj(ScanActivityParticipateObjEnum.TERMINAL.getTransformKey());
            cur.setUserCode(dto.getScanParticipatorCode());
            cur.setName(consumerName);
            cur.setOrgCode(terminalVo.getOrganizationCode());
            cur.setOrgName(terminalVo.getOrganization());
            cur.setChannel(terminalVo.getChannel());
            cur.setRandomFlag(item.getRandomFlag());
            cur.setValueList(this.findRewardValueList(item.getValueList()));
            cur.setItemList(this.findRebateItem(cur, customerCode, item.getRebateList()));
            list.add(cur);
        }
        return list;
    }

    private String findRebateCustomerCode(boolean flag, String userCode, String barCode, String barCodeType, String materialCode) {
        if (!flag) {
            return "";
        }
        Set customerCodeSet = this.terminalSupplyVoService.findTerminalSupplyCustomerCodeSet(userCode, materialCode);
        if (CollectionUtils.isEmpty((Collection)customerCodeSet)) {
            return "";
        }
        if (customerCodeSet.size() > 1) {
            ScanBarCodeRecordFindDto scanBarCodeRecordFindDto = new ScanBarCodeRecordFindDto();
            scanBarCodeRecordFindDto.setBarCodeSet((Set)Sets.newHashSet((Object[])new String[]{barCode}));
            scanBarCodeRecordFindDto.setBarCodeType(barCodeType);
            scanBarCodeRecordFindDto.setParticipatorType(ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
            scanBarCodeRecordFindDto.setUserCodeSet(customerCodeSet);
            return this.scanCodeRecordVoService.findLastScanUserCodeByScanBarCodeRecordFindDto(scanBarCodeRecordFindDto);
        }
        return customerCodeSet.stream().findFirst().orElse("");
    }

    private List<ScanActivityRewardObserverVo> findRebateItem(ScanActivityRewardObserverVo reward, String customerCode, List<ScanActivityRebateVo> rebateList) {
        if (StringUtils.isBlank((CharSequence)customerCode) || CollectionUtils.isEmpty(rebateList)) {
            return Lists.newLinkedList();
        }
        DealerVo dealerVo = this.dealerVoService.findByCustomerCode(customerCode);
        Validate.notNull((Object)dealerVo, (String)"\u53cd\u5411\u5206\u5229\u7684\u7ecf\u9500\u5546\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String customerName = dealerVo.getCustomerName();
        ArrayList re = Lists.newArrayList();
        for (ScanActivityRebateVo item : rebateList) {
            if (!ScanActivityRebateObjTypeEnum.CUSTOMER.getDictCode().equals(item.getObjType())) continue;
            ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
            cur.setUserCode(customerCode);
            cur.setName(customerName);
            cur.setScanActCode(reward.getScanActCode());
            cur.setAccountCode(reward.getAccountCode());
            cur.setChannel(dealerVo.getChannelCode());
            cur.setOrgCode(dealerVo.getOrgCode());
            cur.setOrgName(dealerVo.getOrgName());
            cur.setMaterialCode(reward.getMaterialCode());
            cur.setTriggerAction(reward.getTriggerAction());
            cur.setRecordCode(reward.getRecordCode());
            ScanActivityRewardTypeEnum rewardTypeEnum = ScanActivityRewardTypeEnum.findByDictCode((String)item.getRewardType());
            if (Objects.isNull(rewardTypeEnum)) continue;
            cur.setRewardType(rewardTypeEnum.getTransformKey());
            cur.setRandomFlag(item.getRandomFlag());
            cur.setParticipateObj(ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
            cur.setValueList(this.findRebateValueList(item.getValueList()));
            re.add(cur);
        }
        return re;
    }

    private List<RewardValueVo> findRebateValueList(List<ScanActivityRebateValueVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        for (ScanActivityRebateValueVo item : list) {
            RewardValueVo cur = new RewardValueVo();
            cur.setPercent(item.getRate());
            cur.setCash(item.getRebateValue());
            re.add(cur);
        }
        return re;
    }

    private List<RewardValueVo> findRewardValueList(List<ScanActivityRewardValueVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        for (ScanActivityRewardValueVo item : list) {
            RewardValueVo cur = new RewardValueVo();
            cur.setPercent(item.getRate());
            cur.setCash(item.getRewardValue());
            re.add(cur);
        }
        return re;
    }
}

