/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.register.user;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanActivityParticipateScopeByCustomerRegisterImpl
implements ScanActivityParticipateScopeRegister {
    @Autowired
    private DealerVoService dealerVoService;

    public String getType() {
        return "customer";
    }

    public String getTypeDesc() {
        return "\u7ecf\u9500\u5546";
    }

    public int sort() {
        return 1;
    }

    public Set<String> findScopeCodeSet(String participateScope, List<ScanActivityParticipateScopeDto> list) {
        if (StringUtils.isBlank((CharSequence)participateScope) || CollectionUtils.isEmpty(list)) {
            return Sets.newHashSet();
        }
        Set<String> relateCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(ScanActivityParticipateScopeDto::getRelateCode).collect(Collectors.toSet());
        if (ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
            return Sets.newHashSet();
        }
        if (ScanActivityScopeEnum.SPECIAL.getDictCode().equals(participateScope)) {
            return relateCodeSet;
        }
        Map map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode()) && StringUtils.isNotBlank((CharSequence)a.getParticipateScopeType())).collect(Collectors.groupingBy(ScanActivityParticipateScopeDto::getParticipateScopeType, Collectors.mapping(ScanActivityParticipateScopeDto::getRelateCode, Collectors.toSet())));
        if (map.isEmpty()) {
            return Sets.newHashSet();
        }
        ArrayList orgCodeList = Lists.newArrayList((Iterable)map.getOrDefault(ScanActivityParticipateScopeTypeEnum.ORG.getDictCode(), Sets.newHashSet()));
        ArrayList channelList = Lists.newArrayList((Iterable)map.getOrDefault(ScanActivityParticipateScopeTypeEnum.CHANNEL.getDictCode(), Sets.newHashSet()));
        ArrayList tagList = Lists.newArrayList((Iterable)map.getOrDefault(ScanActivityParticipateScopeTypeEnum.TAG.getDictCode(), Sets.newHashSet()));
        return this.dealerVoService.findCustomerCodesByOrgCodesAndChannelsAndTags((List)orgCodeList, (List)channelList, (List)tagList);
    }

    public Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet) {
        if (CollectionUtils.isEmpty(userCodeSet)) {
            return Maps.newHashMap();
        }
        List voList = this.dealerVoService.findByCustomerCodes((List)Lists.newArrayList(userCodeSet));
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (DealerVo item : voList) {
            item.setOrgNameStr(item.getOrgName());
            map.put(item.getCustomerCode(), (JSONObject)JSONObject.toJSON((Object)item));
        }
        return map;
    }
}

