/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.scan.local.service.register.user;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanActivityParticipateScopeByShopperRegisterImpl
implements ScanActivityParticipateScopeRegister {
    @Autowired
    private UserVoService userVoService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    public String getType() {
        return "shopper";
    }

    public String getTypeDesc() {
        return "\u5bfc\u8d2d";
    }

    public int sort() {
        return 3;
    }

    public Set<String> findScopeCodeSet(String participateScope, List<ScanActivityParticipateScopeDto> list) {
        if (StringUtils.isBlank((CharSequence)participateScope) || CollectionUtils.isEmpty(list)) {
            return Sets.newHashSet();
        }
        Set<String> relateCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(ScanActivityParticipateScopeDto::getRelateCode).collect(Collectors.toSet());
        if (ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
            return Sets.newHashSet();
        }
        if (ScanActivityScopeEnum.SPECIAL.getDictCode().equals(participateScope)) {
            return relateCodeSet;
        }
        Map map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode()) && StringUtils.isNotBlank((CharSequence)a.getParticipateScopeType())).collect(Collectors.groupingBy(ScanActivityParticipateScopeDto::getParticipateScopeType, Collectors.mapping(ScanActivityParticipateScopeDto::getRelateCode, Collectors.toSet())));
        if (map.isEmpty()) {
            return Sets.newHashSet();
        }
        ArrayList orgCodeList = Lists.newArrayList((Iterable)map.getOrDefault(ScanActivityParticipateScopeTypeEnum.ORG.getDictCode(), Sets.newHashSet()));
        ArrayList positionList = Lists.newArrayList((Iterable)map.getOrDefault(ScanActivityParticipateScopeTypeEnum.POSITION.getDictCode(), Sets.newHashSet()));
        return this.userVoService.findUserNamesByCodesAndUserType((List)orgCodeList, (List)positionList, UserTypeEnum.USER_GUIDE.getCode());
    }

    public Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet) {
        if (CollectionUtils.isEmpty(userCodeSet)) {
            return Maps.newHashMap();
        }
        List voList = this.userFeignVoService.findByUserNames(new ArrayList<String>(userCodeSet));
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (UserVo item : voList) {
            map.put(item.getUserName(), (JSONObject)JSONObject.toJSON((Object)item));
        }
        return map;
    }
}

