/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.dynamictask;

import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.bizunited.platform.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AgreementDynamicTask {
    @Autowired
    private AgreementService agreementService;

    @Transactional
    @DynamicTaskService(cornExpression="1 0 0 * * ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u534f\u8bae\u72b6\u6001")
    public void updateAgreementStatus() {
        List<Agreement> list = this.agreementService.findByCurrentTime(new Date());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(agreement -> {
            if (AgreementStatusEnum.NOT_STARTED.getCode().equals(agreement.getAgreementStatus())) {
                agreement.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
            }
            if (AgreementStatusEnum.EXECUTING.getCode().equals(agreement.getAgreementStatus())) {
                agreement.setAgreementStatus(AgreementStatusEnum.COMPLETED.getCode());
            }
        });
        this.agreementService.createOrUpdateBatch(list);
    }
}

