/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.agreement.local.service.notifier;

import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.product.sdk.dto.MaterialDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductDimensionDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanCodeRecordEventListenerImpl
implements ScanCodeRecordEventListener {
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired(required=false)
    private List<AgreementPolicyServiceObserver> agreementPolicyServiceObserver;
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    public void onSuccessScan(ScanCodeRecordEventDto scanCodeRecordEventDto) {
        List<AgreementVo> agreementVos = this.findAgreementVos(scanCodeRecordEventDto);
        Set<String> templateCodes = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(templateCodes)) {
            return;
        }
        MaterialDimensionDto materialDimensionDto = this.findMaterialDimension(scanCodeRecordEventDto.getProductCode());
        PolicyObserverDto policyObserverDto = this.buildPolicyObserverDto(scanCodeRecordEventDto, templateCodes, null, materialDimensionDto);
        this.callPolicyObservers(policyObserverDto);
    }

    private PolicyObserverDto buildPolicyObserverDto(ScanCodeRecordEventDto scanCodeRecordEventDto, Set<String> templateCodes, ProductDimensionDto productDimensionDto, MaterialDimensionDto materialDimensionDto) {
        PolicyObserverDto policyObserverDto = new PolicyObserverDto();
        policyObserverDto.setTemplateCodes(templateCodes);
        policyObserverDto.setBarCodeType(scanCodeRecordEventDto.getBarCodeType());
        policyObserverDto.setParticipatorCode(scanCodeRecordEventDto.getScanParticipatorCode());
        String participatorType = scanCodeRecordEventDto.getParticipatorType();
        ParticipatorTypeEnum typeEnum = ParticipatorTypeEnum.getByKey((String)participatorType);
        policyObserverDto.setParticipatorType(typeEnum.getDictCode());
        policyObserverDto.setProductCode(scanCodeRecordEventDto.getProductCode());
        policyObserverDto.setRecordCode(scanCodeRecordEventDto.getRecordCode());
        policyObserverDto.setProductDimensionDto(productDimensionDto);
        policyObserverDto.setMaterialDimensionDto(materialDimensionDto);
        return policyObserverDto;
    }

    private MaterialDimensionDto findMaterialDimension(String materialCode) {
        Validate.notNull((Object)this.materialVoService, (String)"\u7cfb\u7edf\u7c7b\u7f3a\u5c11MaterialVoService\u5b9e\u73b0", (Object[])new Object[0]);
        MaterialDimensionVo materialDimensionVo = this.materialVoService.findByMaterialCode(materialCode);
        Validate.notNull((Object)materialDimensionVo, (String)"\u7269\u6599/\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (MaterialDimensionDto)this.nebulaToolkitService.copyObjectByBlankList((Object)materialDimensionVo, MaterialDimensionDto.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private List<AgreementVo> findAgreementVos(ScanCodeRecordEventDto scanCodeRecordEventDto) {
        Validate.notNull((Object)scanCodeRecordEventDto, (String)"\u626b\u7801\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        if (BarCodeTypeEnum.COVER_CODE.getFlag().equals(scanCodeRecordEventDto.getBarCodeType())) {
            ConsumerScanCodeDto consumerScanCodeDto = scanCodeRecordEventDto.getConsumerScanCodeDto();
            this.buildLoginUserAgreementDto(consumerScanCodeDto.getBarCodeParticipatorCode(), consumerScanCodeDto.getParticipatorType(), loginUserAgreementDto);
        } else {
            this.buildLoginUserAgreementDto(scanCodeRecordEventDto.getBarCodeParticipatorCode(), scanCodeRecordEventDto.getParticipatorType(), loginUserAgreementDto);
        }
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)agreementVos) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u6761\u7801\u6240\u5173\u8054\u7684\u534f\u8bae\u4fe1\u606f\uff01", (Object[])new Object[0]);
        return agreementVos;
    }

    private void buildLoginUserAgreementDto(String barCodeParticipatorCode, String participatorType, LoginUserAgreementDto loginUserAgreementDto) {
        if (ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)) {
            loginUserAgreementDto.setTerminalCode(barCodeParticipatorCode);
        } else if (ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)) {
            loginUserAgreementDto.setCustomerCode(barCodeParticipatorCode);
        }
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    }

    private void callPolicyObservers(PolicyObserverDto policyObserverDto) {
        if (CollectionUtils.isEmpty(this.agreementPolicyServiceObserver)) {
            return;
        }
        for (AgreementPolicyServiceObserver policyServiceObserver : this.agreementPolicyServiceObserver) {
            policyServiceObserver.onProcessScanCode(policyObserverDto);
        }
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }
}

