package com.biz.crm.cps.business.cash.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 兑现推送状态类型
 *
 * @author ning.zhang
 * @date 2021/12/30
 */
public enum CashPushStatusEnum {
  /**
   * 已打款
   */
  WAIT_PUSH("waitPush", "1", "待推送", "1"),
  /**
   * 未打款
   */
  PUSH_SUCCESS("pushSuccess", "2", "推送成功", "2"),
  /**
   * 打款中
   */
  PUSH_FAIL("pushFail", "3", "推送失败", "3"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CashPushStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CashStatusEnum
   *
   * @param key
   * @return
   */
  public static CashPushStatusEnum getByKey(String key) {
    return Arrays.stream(CashPushStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
