package com.biz.crm.cps.business.cash.sdk.register;

import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;

import java.util.List;
import java.util.Map;

/**
 * 兑现打款注册器
 *
 * @author ning.zhang
 * @date 2021/12/29
 */
public interface CashPayRegister {

  /**
   * 获取打款注册器key
   *
   * @return 打款注册器key
   */
  String getKey();

  /**
   * 获取打款注册器k名称
   *
   * @return 打款注册器名称
   */
  String getName();

  /**
   * 兑现打款操作
   *
   * @param cashRecords 兑换记录列表
   * @return 兑换流水号和打款号映射关系
   */
  Map<String,String> pay(List<CashRecordVo> cashRecords);
}
