package com.biz.crm.cps.business.cash.sdk.service;

import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordPayDto;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;

/**
 * @author hecheng
 * @description: 提现记录Voservice
 * @date 2021/8/31 下午4:56
 */
public interface CashRecordVoService {

  /**
   * 生成提现流水
   *
   * @param cashRecordDto
   * @return
   */
  CashRecordVo create(CashRecordDto cashRecordDto);

  /**
   * 更新兑付状态
   * @param cashRecordDto
   */
  void updateCashStatus(CashRecordDto cashRecordDto);

  /**
   * 根据付款流水编号更改付款记录状态(税筹调用)
   * @param cashRecordPayDto
   */
  void updateStatusByCashRecordCode(CashRecordPayDto cashRecordPayDto);
}
