package com.biz.crm.cps.business.cash.sdk.service.observer;

/**
 * 分利兑现挂载接口 账房云,微信红包等模块实现该接口，让兑现模块知道系统中已经存在的实现
 *
 * @author hecheng
 * @date 2021/08/26
 */
public interface CashMountRegister {

  /**
   * 兑现方式中文名称 具体账房云,微信红包等实现该方法，告知兑现方式的中文名（注意，具体的兑现方式中，设定的该信息不能重复）
   *
   * @return
   */
  String getName();

  /**
   * 兑现方式key 具体账房云,微信红包等实现该方法，告知兑现方式的英文key（注意，具体的兑现方式中，设定的该信息不能重复）
   *
   * @return
   */
  String getKey();

  /**
   * 兑现方式flag 具体账房云,微信红包等实现该方法，告知兑现方式的标识数字（注意，具体的兑现方式中，设定的该信息不能重复）
   *
   * @return
   */
  String getFlag();

  /**
   * 是否需要签署协议
   *
   * @return
   */
  boolean needSign();

  /**
   * 是否需要实名认证
   *
   * @return
   */
  boolean needSignVerify();
}
