package com.biz.crm.cps.business.cash.sdk.service.observer;

import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;

/**
 * 兑现 观察者 由具体提现方式实现 需要提供本方式需要的提现流程
 *
 * @author hecheng
 * @date 2021/08/26
 */
public interface CashServiceObserver {

  /**
   * 获取提现流程 是否需要认证 是否需要签署协议 1.判断是否该本模块处理该提现
   *
   * @param cashCondition
   */
  CashProcessVo onRequestCashProcess(CashConditionDto cashCondition);

  /**
   * 通知创建合同
   *
   * @param cashCondition
   */
  CashProcessVo onCreateContract(CashConditionDto cashCondition);

  /**
   * 当所有提现前置条件均满足时 开始提现工作
   * @param cashCondition
   */
  CashRecordVo onCash(CashConditionDto cashCondition);
}
