package com.biz.crm.cps.business.cash.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hecheng
 * @description: 兑付配置Vo
 * @date 2021/9/1 上午10:48
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CashConfiguration", description = "兑付配置Vo")
public class CashConfigurationVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -7937631814788805961L;

  /**
   * 签约者编码 指当前登录用户（终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("签约编码")
  private String signatoryCode;

  /**
   * 签约者账户名称
   */
  @ApiModelProperty("签约者名称")
  private String signatoryName;

  /**
   * 签约者类型  终端/经销商 消费者
   */
  @ApiModelProperty("签约者类型")
  private String signatoryType;
  /**
   * 兑付类型标志
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  private String cashMethodName;

}
