/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.mapper.TerminalMapper;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TerminalRepository
extends ServiceImpl<TerminalMapper, Terminal> {
    @Resource
    private TerminalMapper terminalMapper;

    public Terminal findDetailsById(String id) {
        return this.terminalMapper.findDetailsById(id);
    }

    public Page<Terminal> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalMapper.findByConditions((Page<Terminal>)page, terminalPaginationDto);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateAuditStatusById(String dictCode, String id) {
        if (StringUtils.isBlank((CharSequence)id) || Objects.isNull(dictCode)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"audit_status", (Object)dictCode);
        updateWrapper.eq((Object)"id", (Object)id);
        this.update((Wrapper)updateWrapper);
    }

    public List<Terminal> findByIdIn(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        return this.list((Wrapper)wrapper);
    }

    public Terminal findByOpenId(String openId) {
        if (StringUtils.isBlank((CharSequence)openId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"open_id", (Object)openId);
        return (Terminal)((Object)this.getOne((Wrapper)wrapper));
    }

    public Terminal findByRegistrationNumber(String registrationNumber) {
        if (StringUtils.isBlank((CharSequence)registrationNumber)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"registration_number", (Object)registrationNumber);
        return (Terminal)((Object)this.getOne((Wrapper)wrapper));
    }

    public Terminal findByTerminalCode(String terminalCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"terminal_code", (Object)terminalCode);
        return (Terminal)((Object)this.getOne((Wrapper)wrapper));
    }

    public Page<Terminal> findByDealerId(Pageable pageable, String dealerId) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalMapper.findByDealerId((Page<Terminal>)page, dealerId);
    }

    public List<Terminal> findByTerminalCodes(List<String> terminalCodes) {
        return this.terminalMapper.findDetailsByTerminalCodes(terminalCodes);
    }

    public Terminal validate(TerminalVo terminal) {
        QueryWrapper registrationNumberWrapper = new QueryWrapper();
        registrationNumberWrapper.eq((Object)"registration_number", (Object)terminal.getRegistrationNumber());
        Terminal dbTerminal = (Terminal)((Object)this.getOne((Wrapper)registrationNumberWrapper));
        if (dbTerminal != null) {
            return dbTerminal;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"terminal_name", (Object)terminal.getTerminalName());
        wrapper.eq((Object)"terminal_address", (Object)terminal.getTerminalAddress());
        dbTerminal = (Terminal)((Object)this.getOne((Wrapper)wrapper));
        return dbTerminal;
    }

    public Terminal findDetailsByTerminalCode(String terminalCode) {
        return this.terminalMapper.findDetailsByTerminalCode(terminalCode);
    }

    public List<String> findByExternalIdentifier(String dealerCode) {
        return this.terminalMapper.findByExternalIdentifier(dealerCode);
    }

    public List<String> findTerminalCode(String tenantCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"terminal_code"});
        wrapper.eq((Object)"tenant_code", (Object)tenantCode);
        return this.listObjs((Wrapper)wrapper, Object::toString);
    }
}

