/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.local.entity.DealerCommunicationEntity;
import com.biz.crm.cps.business.participator.local.entity.DealerContactPersonEntity;
import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.repository.DealerCommunicationRepository;
import com.biz.crm.cps.business.participator.local.repository.DealerContactPersonRepository;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.local.service.ParticipatorTagService;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerCommunicationVo;
import com.biz.crm.cps.business.participator.sdk.vo.DealerContactPersonVo;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DealerVoServiceImpl
implements DealerVoService {
    @Autowired
    private DealerRepository dealerRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DealerContactPersonRepository dealerContactPersonRepository;
    @Autowired
    private DealerCommunicationRepository dealerCommunicationRepository;
    @Autowired
    private ParticipatorTagService participatorTagService;
    @Autowired
    private ParticipatorTagVoService participatorTagVoService;

    public Page<DealerVo> findByConditions(DealerDto dealerDto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        return this.dealerRepository.findByConditions(pageable, dealerDto);
    }

    public DealerVo findDetailById(String id) {
        DealerCommunicationEntity dealerCommunication;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DealerEntity dealerEntity = (DealerEntity)((Object)this.dealerRepository.getById((Serializable)((Object)id)));
        if (dealerEntity == null) {
            return null;
        }
        DealerVo vo = (DealerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerEntity, DealerVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<DealerContactPersonEntity> dealerContactPersons = this.dealerContactPersonRepository.findByDealerId(id);
        if (CollectionUtils.isNotEmpty(dealerContactPersons)) {
            Collection dealerContactPersonVos = this.nebulaToolkitService.copyCollectionByWhiteList(dealerContactPersons, DealerContactPersonEntity.class, DealerContactPersonVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setDealerContactPersons((Set)Sets.newHashSet((Iterable)dealerContactPersonVos));
        }
        if ((dealerCommunication = this.dealerCommunicationRepository.findByDealerId(id)) != null) {
            DealerCommunicationVo dealerCommunicationVo = (DealerCommunicationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerCommunication, DealerCommunicationVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setDealerCommunication(dealerCommunicationVo);
        }
        return vo;
    }

    public DealerVo findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        DealerEntity entity = this.dealerRepository.findByCustomerCode(customerCode);
        if (entity == null) {
            return null;
        }
        return (DealerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DealerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<DealerVo> findByCustomerCodes(List<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            return null;
        }
        List<DealerEntity> entities = this.dealerRepository.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        Collection dealerVos = this.nebulaToolkitService.copyCollectionByWhiteList(entities, DealerEntity.class, DealerVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.setTagDescription(dealerVos);
        return Lists.newArrayList((Iterable)dealerVos);
    }

    public Set<DealerVo> findByConditions(DealerDto dealerDto) {
        Set<DealerVo> dealerVoSet = this.dealerRepository.findByConditions(dealerDto);
        this.setTagDescription(dealerVoSet);
        return dealerVoSet;
    }

    public DealerVo findDetailByCustomerCode(String customerCode) {
        DealerCommunicationEntity dealerCommunication;
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        DealerEntity entity = this.dealerRepository.findByCustomerCode(customerCode);
        if (entity == null) {
            return null;
        }
        DealerVo dealerVo = (DealerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DealerVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<DealerContactPersonEntity> dealerContactPersons = this.dealerContactPersonRepository.findByDealerId(dealerVo.getId());
        if (CollectionUtils.isNotEmpty(dealerContactPersons)) {
            Collection dealerContactPersonVos = this.nebulaToolkitService.copyCollectionByWhiteList(dealerContactPersons, DealerContactPersonEntity.class, DealerContactPersonVo.class, HashSet.class, ArrayList.class, new String[0]);
            dealerVo.setDealerContactPersons((Set)Sets.newHashSet((Iterable)dealerContactPersonVos));
        }
        if ((dealerCommunication = this.dealerCommunicationRepository.findByDealerId(dealerVo.getId())) != null) {
            DealerCommunicationVo dealerCommunicationVo = (DealerCommunicationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerCommunication, DealerCommunicationVo.class, HashSet.class, ArrayList.class, new String[0]);
            dealerVo.setDealerCommunication(dealerCommunicationVo);
        }
        return dealerVo;
    }

    private void setTagDescription(Collection<DealerVo> dealerVoSet) {
        if (!org.springframework.util.CollectionUtils.isEmpty(dealerVoSet)) {
            List codeList = dealerVoSet.stream().map(DealerVo::getCustomerCode).collect(Collectors.toList());
            Map<Object, Object> participatorTagMap = new HashMap();
            List participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)participatorTagList)) {
                participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
            }
            for (DealerVo dealerVo : dealerVoSet) {
                List tags = (List)participatorTagMap.get(dealerVo.getCustomerCode());
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)tags)) continue;
                String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
                dealerVo.setTagDescription(participatorTag);
            }
        }
    }
}

