/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.participator.local.entity.SupplyRelationship;
import com.biz.crm.cps.business.participator.local.repository.SupplyRelationshipRepository;
import com.biz.crm.cps.business.participator.local.service.SupplyRelationshipService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SupplyRelationshipServiceImpl
implements SupplyRelationshipService {
    @Autowired
    SupplyRelationshipRepository supplyRelationshipRepository;

    @Override
    @Transactional
    public SupplyRelationship createForm(SupplyRelationship supplyRelationship) {
        this.createValidation(supplyRelationship);
        supplyRelationship.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return supplyRelationship;
    }

    @Override
    @Transactional
    public void createBatch(Collection<SupplyRelationship> supplyRelationships) {
        if (CollectionUtils.isEmpty(supplyRelationships)) {
            return;
        }
        for (SupplyRelationship supplyRelationship : supplyRelationships) {
            this.createForm(supplyRelationship);
        }
        this.supplyRelationshipRepository.saveBatch(supplyRelationships);
    }

    @Override
    @Transactional
    public void updateBatch(Set<SupplyRelationship> supplyRelationships) {
        if (CollectionUtils.isEmpty(supplyRelationships)) {
            return;
        }
        for (SupplyRelationship supplyRelationship : supplyRelationships) {
            this.updateValidation(supplyRelationship);
        }
        this.supplyRelationshipRepository.saveOrUpdateBatch(supplyRelationships);
    }

    @Override
    public List<SupplyRelationship> findByTerminalId(String terminalId) {
        if (StringUtils.isBlank((CharSequence)terminalId)) {
            return null;
        }
        return this.supplyRelationshipRepository.findByTerminalId(terminalId);
    }

    private void updateValidation(SupplyRelationship supplyRelationship) {
        Validate.notNull((Object)((Object)supplyRelationship), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getTerminalId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4f9b\u8d27\u5173\u7cfb\u7684\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u4e3b\u952e\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSalesman(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSalesmanOrganization(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSuperiorCustomer(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e0a\u7ea7\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getTerminalId() == null || supplyRelationship.getTerminalId().length() < 255 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aefID,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSalesman() == null || supplyRelationship.getSalesman().length() < 128 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSalesmanOrganization() == null || supplyRelationship.getSalesmanOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSuperiorCustomer() == null || supplyRelationship.getSuperiorCustomer().length() < 128 ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createValidation(SupplyRelationship supplyRelationship) {
        Validate.notNull((Object)((Object)supplyRelationship), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)supplyRelationship.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        supplyRelationship.setId(null);
        Validate.notBlank((CharSequence)supplyRelationship.getTerminalId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4f9b\u8d27\u5173\u7cfb\u7684\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u4e3b\u952e\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSalesman(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSalesmanOrganization(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supplyRelationship.getSuperiorCustomer(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e0a\u7ea7\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getTerminalId() == null || supplyRelationship.getTerminalId().length() < 255 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aefID,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSalesman() == null || supplyRelationship.getSalesman().length() < 128 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSalesmanOrganization() == null || supplyRelationship.getSalesmanOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((supplyRelationship.getSuperiorCustomer() == null || supplyRelationship.getSuperiorCustomer().length() < 128 ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

