/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.local.entity.ContactPerson;
import com.biz.crm.cps.business.participator.local.entity.ParticipatorTag;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.entity.TerminalSupplyDetailEntity;
import com.biz.crm.cps.business.participator.local.entity.TerminalSupplyEntity;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.local.service.ContactPersonService;
import com.biz.crm.cps.business.participator.local.service.DealerService;
import com.biz.crm.cps.business.participator.local.service.ParticipatorTagService;
import com.biz.crm.cps.business.participator.local.service.SupplyRelationshipService;
import com.biz.crm.cps.business.participator.local.service.TerminalService;
import com.biz.crm.cps.business.participator.local.service.TerminalSupplyService;
import com.biz.crm.cps.business.participator.local.service.state.TerminalStateHolder;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalAuditStatusEnum;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalSourceEnum;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.event.TerminalEventListener;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorTagMdmService;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.ParticipatorTagMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalContactMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TerminalServiceExpandImpl"})
public class TerminalServiceImpl
implements TerminalService {
    private static final Logger log = LoggerFactory.getLogger(TerminalServiceImpl.class);
    @Autowired
    private TerminalRepository terminalRepository;
    @Autowired
    private ContactPersonService contactPersonService;
    @Autowired
    private SupplyRelationshipService supplyRelationshipService;
    @Autowired
    private ParticipatorTagService participatorTagService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalEventListener> terminalEventListenerList;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired(required=false)
    private ParticipatorTagMdmService participatorTagMdmService;
    @Autowired
    private TerminalStateHolder terminalStateHolder;
    @Autowired
    private DealerService dealerService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private TerminalSupplyService terminalSupplyService;

    @Override
    @Transactional
    public Terminal create(Terminal terminal) {
        terminal.setAuditStatus(TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode());
        terminal.setTerminalSource(TerminalSourceEnum.NEW_TERMINAL.getDictCode());
        Terminal current = this.createForm(terminal);
        this.terminalRepository.save((Object)current);
        this.createChildTable(current);
        return current;
    }

    @Override
    @Transactional
    public Terminal createForm(Terminal terminal) {
        Date now = new Date();
        String account = "";
        account = TerminalSourceEnum.NEW_TERMINAL.getDictCode().equals(terminal.getTerminalSource()) ? terminal.getTerminalName() : this.loginUserService.getLoginUser().getRealName();
        terminal.setTenantCode(TenantUtils.getTenantCode());
        terminal.setCreateAccount(account);
        terminal.setCreateTime(now);
        terminal.setModifyAccount(account);
        terminal.setModifyTime(now);
        terminal.setSubmitTime(now);
        terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidation(terminal);
        return terminal;
    }

    @Override
    @Transactional
    public Terminal update(Terminal terminal) {
        Terminal current = this.updateForm(terminal);
        this.updateChildTable(current);
        return current;
    }

    private void updateChildTable(Terminal terminal) {
        String terminalId = terminal.getId();
        Set<ContactPerson> contactPersons = terminal.getContactPersons();
        if (!CollectionUtils.isEmpty(contactPersons)) {
            contactPersons.removeIf(item -> StringUtils.isBlank((CharSequence)item.getContactPersonPhone()));
            contactPersons.stream().forEach(item -> {
                item.setId(null);
                item.setTerminalId(terminal.getId());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            List<ContactPerson> oldContactPerson = this.contactPersonService.findByTerminalId(terminalId);
            if (!CollectionUtils.isEmpty(oldContactPerson)) {
                oldContactPerson.stream().forEach(contactPerson -> contactPerson.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
                contactPersons.addAll(oldContactPerson);
            }
            this.contactPersonService.updateBatch(contactPersons);
        }
        this.terminalSupplyService.createBatch(terminal.getTerminalSupplies());
        Set<TerminalSupplyEntity> supplyRelationships = terminal.getTerminalSupplies();
        if (!CollectionUtils.isEmpty(supplyRelationships)) {
            this.dealerService.createBatch(supplyRelationships.stream().map(TerminalSupplyEntity::getCustomerCode).collect(Collectors.toSet()));
        }
    }

    @Override
    @Transactional
    public Terminal updateForm(Terminal terminal) {
        Terminal currentTerminal;
        this.updateValidation(terminal);
        if (StringUtils.isEmpty((CharSequence)terminal.getId()) || StringUtils.isEmpty((CharSequence)terminal.getTerminalCode())) {
            currentTerminal = this.terminalRepository.findByTerminalCode(terminal.getTerminalCode());
        } else {
            String currentId = terminal.getId();
            currentTerminal = (Terminal)((Object)this.terminalRepository.getById((Serializable)((Object)currentId)));
        }
        Validate.notNull((Object)((Object)currentTerminal), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentTerminal.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        terminal.setTenantCode(currentTerminal.getTenantCode());
        TerminalVo oldVo = null;
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            oldVo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTerminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        Date now = new Date();
        String account = "admin";
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        if (loginUser != null) {
            account = loginUser.getPostName();
        }
        currentTerminal.setModifyAccount(account);
        currentTerminal.setModifyTime(now);
        BeanUtils.copyProperties((Object)((Object)terminal), (Object)((Object)currentTerminal), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode", "openId"});
        this.terminalRepository.saveOrUpdate((Object)currentTerminal);
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            TerminalVo newVo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTerminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (TerminalEventListener event : this.terminalEventListenerList) {
                event.onChange(oldVo, newVo);
            }
        }
        return currentTerminal;
    }

    @Override
    public Terminal findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Terminal)((Object)this.terminalRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Terminal findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.terminalRepository.findDetailsById(id);
    }

    @Override
    public Terminal findDetailsByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.terminalRepository.findDetailsByTerminalCode(terminalCode);
    }

    @Override
    public void pushToMdm(String terminalCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Terminal terminal = this.terminalRepository.findByTerminalCode(terminalCode);
        List<ContactPerson> contactPersons = this.contactPersonService.findByTerminalId(terminal.getId());
        if (!CollectionUtils.isEmpty(contactPersons)) {
            terminal.setContactPersons(Sets.newHashSet(contactPersons));
        }
        TerminalMdmVo terminalMdmVo = this.buildTerminalMdmVo(terminal);
        this.terminalMdmService.save(terminalMdmVo);
    }

    @Override
    @Transactional
    public List<Terminal> createBatchByTerminalList(List<Terminal> terminalList) {
        Validate.notEmpty(terminalList, (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set codes = terminalList.stream().map(Terminal::getTerminalCode).collect(Collectors.toSet());
        List terminalMdmVos = this.terminalMdmService.findDetailByCodes(codes);
        Validate.notEmpty((Collection)terminalMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u51c6\u5165\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        List<Terminal> terminals = this.convertModel(terminalMdmVos);
        List participatorTagMdmVos = this.participatorTagMdmService.findTagsByCodes(codes);
        Collection participatorTags = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)participatorTagMdmVos, ParticipatorTagMdmVo.class, ParticipatorTag.class, HashSet.class, LinkedList.class, new String[0]);
        Map<String, List<ParticipatorTag>> codeMapTag = participatorTags.stream().collect(Collectors.groupingBy(ParticipatorTag::getParticipatorCode));
        for (Terminal terminal : terminals) {
            List<ParticipatorTag> tags = codeMapTag.get(terminal.getTerminalCode());
            if (CollectionUtils.isEmpty(tags)) continue;
            terminal.setParticipatorTags(Sets.newHashSet(tags));
        }
        return this.createBatch(terminals);
    }

    @Override
    public List<String> findTerminalCode() {
        return this.terminalRepository.findTerminalCode(TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void push(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalMdmVo terminalMdmVo = this.buildTerminalMdmVo(terminal);
        this.terminalMdmService.save(terminalMdmVo);
    }

    private List<Terminal> convertModel(List<TerminalMdmVo> terminalMdmVos) {
        LinkedList terminals = Lists.newLinkedList();
        for (TerminalMdmVo terminalMdmVo : terminalMdmVos) {
            log.debug("TerminalMdmVo=={}", (Object)terminalMdmVo.toString());
            Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalMdmVo, Terminal.class, HashSet.class, LinkedList.class, new String[0]));
            terminal.setOrganization(terminalMdmVo.getOrgName());
            terminal.setOrganizationCode(terminalMdmVo.getOrgCode());
            terminal.setCustomerOrganization(terminalMdmVo.getCustomerOrgName());
            terminal.setCustomerOrganizationCode(terminalMdmVo.getCustomerOrgCode());
            terminal.setChannel(terminalMdmVo.getChannel());
            terminal.setChannelName(terminalMdmVo.getChannelName());
            terminal.setShopSignPath(terminalMdmVo.getShopImagePath());
            terminal.setShopSignFilename(terminalMdmVo.getShopImagePath());
            terminal.setBusinessLicensePath(terminalMdmVo.getLicenseImagePath());
            terminal.setBusinessLicenseFilename(terminalMdmVo.getLicenseImagePath());
            terminal.setLegalPersonSName(terminalMdmVo.getLicensePersonName());
            terminal.setRegistrationNumber(terminalMdmVo.getLicenseRegisterNumber());
            terminal.setCompanyName(terminalMdmVo.getLicenseFirmName());
            HashSet supplyEntities = Sets.newHashSet();
            List supplys = terminalMdmVo.getSupplys();
            if (!CollectionUtils.isEmpty((Collection)supplys)) {
                for (TerminalSupplyVo supply : supplys) {
                    TerminalSupplyEntity supplyEntity = (TerminalSupplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)supply, TerminalSupplyEntity.class, HashSet.class, ArrayList.class, new String[0]));
                    List details = supply.getDetails();
                    if (!CollectionUtils.isEmpty((Collection)details)) {
                        supplyEntity.setTerminalSupplyDetails((List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)details, TerminalSupplyDetailVo.class, TerminalSupplyDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
                    }
                    supplyEntities.add(supplyEntity);
                }
            }
            terminal.setTerminalSupplies(supplyEntities);
            terminal.setLocation(StringUtils.join((Object[])new String[]{terminalMdmVo.getLatitude(), ",", terminalMdmVo.getLongitude()}));
            List contacts = terminalMdmVo.getContacts();
            if (!CollectionUtils.isEmpty((Collection)contacts)) {
                HashSet contactPersonSet = Sets.newHashSet();
                for (TerminalContactMdmVo contact : contacts) {
                    ContactPerson contactPerson = new ContactPerson();
                    contactPerson.setContactPersonName(contact.getContactName());
                    contactPerson.setContactPersonPhone(contact.getContactPhone());
                    contactPersonSet.add(contactPerson);
                }
                terminal.setContactPersons(contactPersonSet);
            }
            terminals.add(terminal);
        }
        return terminals;
    }

    @Override
    public Page<Terminal> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
        terminalPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findByConditions(pageable, terminalPaginationDto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Terminal> terminalList = this.terminalRepository.findByIdIn(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        terminalList.forEach(terminal -> Validate.isTrue((boolean)EnableStatusEnum.DISABLE.getCode().equals(terminal.getEnableStatus()), (String)"\u53ea\u80fd\u542f\u7528\u7981\u7528\u72b6\u6001\u6570\u636e", (Object[])new Object[0]));
        this.terminalRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List<Terminal> terminalList = this.terminalRepository.findByIdIn(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        terminalList.forEach(terminal -> Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(terminal.getEnableStatus()), (String)"\u53ea\u80fd\u7981\u7528\u542f\u7528\u72b6\u6001\u6570\u636e", (Object[])new Object[0]));
        this.terminalRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (TerminalEventListener event : this.terminalEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    @Transactional
    public List<Terminal> createBatch(List<Terminal> terminalList) {
        Validate.isTrue((!CollectionUtils.isEmpty(terminalList) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        for (Terminal terminal : terminalList) {
            terminal.setId(null);
            terminal.setAuditStatus(TerminalAuditStatusEnum.AUDIT_SUCCESS.getDictCode());
            terminal.setTerminalSource(TerminalSourceEnum.DEALER_TERMINAL.getDictCode());
            this.createForm(terminal);
        }
        this.terminalRepository.saveBatch(terminalList);
        HashSet set = Sets.newHashSet();
        for (Terminal terminal : terminalList) {
            this.createChildTable(terminal);
            Set<TerminalSupplyEntity> supplyRelationships = terminal.getTerminalSupplies();
            if (CollectionUtils.isEmpty(supplyRelationships)) continue;
            for (TerminalSupplyEntity terminalSupplyEntity : supplyRelationships) {
                String externalIdentifier = terminalSupplyEntity.getCustomerCode();
                set.add(externalIdentifier);
            }
        }
        this.dealerService.createBatch(set);
        return terminalList;
    }

    private void createChildTable(Terminal terminal) {
        Set<ParticipatorTag> participatorTags;
        Set<TerminalSupplyEntity> terminalSupplyEntities;
        Set<ContactPerson> contactPersons = terminal.getContactPersons();
        if (!CollectionUtils.isEmpty(contactPersons)) {
            contactPersons.stream().forEach(item -> item.setTerminalId(terminal.getId()));
            this.contactPersonService.createBatch(contactPersons);
        }
        if (!CollectionUtils.isEmpty(terminalSupplyEntities = terminal.getTerminalSupplies())) {
            this.terminalSupplyService.createBatch(terminalSupplyEntities);
        }
        if (!CollectionUtils.isEmpty(participatorTags = terminal.getParticipatorTags())) {
            participatorTags.stream().forEach(item -> item.setParticipatorCode(terminal.getTerminalCode()));
            this.participatorTagService.createBatch(participatorTags);
        }
    }

    @Override
    @Transactional
    public void pass(String id) {
        Terminal terminal = this.findDetailsById(id);
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode().equals(terminal.getAuditStatus()), (String)String.format("\u53ea\u80fd\u5ba1\u6279%s\u72b6\u6001\u7684\u7ec8\u7aef", TerminalAuditStatusEnum.UNDER_REVIEW.getValue()), (Object[])new Object[0]);
        this.terminalStateHolder.pass(terminal);
    }

    @Override
    @Transactional
    public void cancel(String id) {
        Terminal terminal = this.findById(id);
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode().equals(terminal.getAuditStatus()), (String)String.format("\u53ea\u80fd\u9a73\u56de%s\u72b6\u6001\u7684\u7ec8\u7aef", TerminalAuditStatusEnum.UNDER_REVIEW.getValue()), (Object[])new Object[0]);
        this.terminalStateHolder.cancel(terminal);
    }

    @Override
    public Terminal findByOpenId(String openId) {
        if (StringUtils.isBlank((CharSequence)openId)) {
            return null;
        }
        return this.terminalRepository.findByOpenId(openId);
    }

    @Override
    public Terminal findByRegistrationNumber(String registrationNumber) {
        if (StringUtils.isBlank((CharSequence)registrationNumber)) {
            return null;
        }
        return this.terminalRepository.findByRegistrationNumber(registrationNumber);
    }

    @Override
    public Terminal findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.terminalRepository.findByTerminalCode(terminalCode);
    }

    @Override
    public Page<Terminal> findByDealerId(String dealerId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)dealerId)) {
            return new Page();
        }
        return this.terminalRepository.findByDealerId(pageable, dealerId);
    }

    @Override
    @Transactional
    public void create(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        List terminalMdmVos = this.terminalMdmService.findByConditions(terminalMdmPaginationDto);
        Validate.notEmpty((Collection)terminalMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u51c6\u5165\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        List<Terminal> terminals = this.convertModel(terminalMdmVos);
        this.createBatch(terminals);
    }

    private void createValidation(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)terminal.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        terminal.setId(null);
        Validate.notBlank((CharSequence)terminal.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getLegalPersonSName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getCompanyName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalType() == null || terminal.getTerminalType().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalSource() == null || terminal.getTerminalSource().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u6765\u6e90,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOrganization() == null || terminal.getOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCustomerOrganization() == null || terminal.getCustomerOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getLegalPersonSName() == null || terminal.getLegalPersonSName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getRegistrationNumber() == null || terminal.getRegistrationNumber().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCompanyName() == null || terminal.getCompanyName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceCode() == null || terminal.getProvinceCode().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceName() == null || terminal.getProvinceName().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityCode() == null || terminal.getCityCode().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityName() == null || terminal.getCityName().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictCode() == null || terminal.getDistrictCode().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictName() == null || terminal.getDistrictName().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalAddress() == null || terminal.getTerminalAddress().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u5730\u5740,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignPath() == null || terminal.getShopSignPath().length() < 255 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignFilename() == null || terminal.getShopSignFilename().length() < 255 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicensePath() == null || terminal.getBusinessLicensePath().length() < 255 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicenseFilename() == null || terminal.getBusinessLicenseFilename().length() < 255 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOpenId() == null || terminal.getOpenId().length() < 64 ? 1 : 0) != 0, (String)"openId,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Terminal db = this.findByTerminalCode(terminal.getTerminalCode());
        Validate.isTrue((boolean)Objects.isNull((Object)db), (String)"\u7ec8\u7aef\u5df2\u51c6\u5165\uff1a%s", (Object[])new Object[]{terminal.getTerminalName()});
    }

    private void updateValidation(Terminal terminal) {
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getLegalPersonSName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getCompanyName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalType() == null || terminal.getTerminalType().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7c7b\u578b,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalSource() == null || terminal.getTerminalSource().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u6765\u6e90,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOrganization() == null || terminal.getOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCustomerOrganization() == null || terminal.getCustomerOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getLegalPersonSName() == null || terminal.getLegalPersonSName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getRegistrationNumber() == null || terminal.getRegistrationNumber().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCompanyName() == null || terminal.getCompanyName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceCode() == null || terminal.getProvinceCode().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceName() == null || terminal.getProvinceName().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityCode() == null || terminal.getCityCode().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityName() == null || terminal.getCityName().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictCode() == null || terminal.getDistrictCode().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictName() == null || terminal.getDistrictName().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalAddress() == null || terminal.getTerminalAddress().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u5730\u5740,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignPath() == null || terminal.getShopSignPath().length() < 255 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignFilename() == null || terminal.getShopSignFilename().length() < 255 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicensePath() == null || terminal.getBusinessLicensePath().length() < 255 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicenseFilename() == null || terminal.getBusinessLicenseFilename().length() < 255 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOpenId() == null || terminal.getOpenId().length() < 64 ? 1 : 0) != 0, (String)"openId,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private TerminalMdmVo buildTerminalMdmVo(Terminal current) {
        Set<ContactPerson> contactPersons = current.getContactPersons();
        List contactPersonVos = null;
        TerminalMdmVo terminalMdmVo = (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, TerminalMdmVo.class, HashSet.class, ArrayList.class, new String[0]);
        terminalMdmVo.setOrgCode(current.getOrganization());
        terminalMdmVo.setFromType("cps");
        terminalMdmVo.setCustomerOrgCode(current.getCustomerOrganization());
        terminalMdmVo.setLicensePersonName(current.getLegalPersonSName());
        terminalMdmVo.setLicenseRegisterNumber(current.getRegistrationNumber());
        terminalMdmVo.setLicenseFirmName(current.getCompanyName());
        terminalMdmVo.setTerminalAddress(current.getTerminalAddress());
        terminalMdmVo.setShopImagePath(current.getShopSignPath());
        terminalMdmVo.setLicenseImagePath(current.getBusinessLicensePath());
        if (!CollectionUtils.isEmpty(contactPersons)) {
            contactPersonVos = contactPersons.stream().map(item -> {
                TerminalContactMdmVo vo = new TerminalContactMdmVo();
                vo.setContactMain("1");
                vo.setContactName(item.getContactPersonName());
                vo.setContactPhone(item.getContactPersonPhone());
                return vo;
            }).collect(Collectors.toList());
            terminalMdmVo.setContacts(contactPersonVos);
        }
        return terminalMdmVo;
    }

    @Override
    @Transactional
    public void createBatchByPhone(String phone) {
        Validate.notBlank((CharSequence)phone, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List terminalMdmVos = this.terminalMdmService.findByPhone(phone);
        Validate.notEmpty((Collection)terminalMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u51c6\u5165\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        List<Terminal> terminals = this.convertModel(terminalMdmVos);
        Set codes = terminals.stream().map(Terminal::getTerminalCode).collect(Collectors.toSet());
        List participatorTagMdmVos = this.participatorTagMdmService.findTagsByCodes(codes);
        Collection participatorTags = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)participatorTagMdmVos, ParticipatorTagMdmVo.class, ParticipatorTag.class, HashSet.class, LinkedList.class, new String[0]);
        Map<String, List<ParticipatorTag>> codeMapTag = participatorTags.stream().collect(Collectors.groupingBy(ParticipatorTag::getParticipatorCode));
        for (Terminal terminal : terminals) {
            List<ParticipatorTag> tags = codeMapTag.get(terminal.getTerminalCode());
            if (!CollectionUtils.isEmpty(tags)) {
                terminal.setParticipatorTags(Sets.newHashSet(tags));
            }
            this.convertIdModel(terminal);
            terminal.setAuditStatus(TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode());
            terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            terminal.setTerminalSource(TerminalSourceEnum.NEW_TERMINAL.getDictCode());
            Terminal current = this.createForm(terminal);
            this.terminalRepository.save((Object)current);
            this.createChildTable(current);
        }
    }

    private void convertIdModel(Terminal terminal) {
        terminal.setId(null);
        Set<ContactPerson> contactPersons = terminal.getContactPersons();
        Set<TerminalSupplyEntity> supplyRelationships = terminal.getTerminalSupplies();
        if (!CollectionUtils.isEmpty(contactPersons)) {
            contactPersons.stream().forEach(item -> item.setId(null));
        }
        if (!CollectionUtils.isEmpty(supplyRelationships)) {
            supplyRelationships.stream().forEach(item -> item.setId(null));
        }
    }
}

