/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.participator.local.entity.TerminalSupplyDetailEntity;
import com.biz.crm.cps.business.participator.local.entity.TerminalSupplyEntity;
import com.biz.crm.cps.business.participator.local.mapper.TerminalSupplyMapper;
import com.biz.crm.cps.business.participator.local.repository.TerminalSupplyDetailRepository;
import com.biz.crm.cps.business.participator.local.repository.TerminalSupplyRepository;
import com.biz.crm.cps.business.participator.local.service.TerminalSupplyService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TerminalSupplyServiceExpandImpl"})
public class TerminalSupplyServiceImpl
implements TerminalSupplyService {
    private static final Logger log = LoggerFactory.getLogger(TerminalSupplyServiceImpl.class);
    @Autowired
    private TerminalSupplyRepository terminalSupplyRepository;
    @Autowired
    private TerminalSupplyDetailRepository terminalSupplyDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void updateSupply(TerminalMdmVo vo) {
        List supplys;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)vo.getTerminalCode());
        List terminalSupplyEntities = ((TerminalSupplyMapper)this.terminalSupplyRepository.getBaseMapper()).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)terminalSupplyEntities)) {
            this.terminalSupplyDetailRepository.deleteBySupplyId(terminalSupplyEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            ((TerminalSupplyMapper)this.terminalSupplyRepository.getBaseMapper()).delete((Wrapper)queryWrapper);
        }
        if (!CollectionUtils.isEmpty((Collection)(supplys = vo.getSupplys()))) {
            for (TerminalSupplyVo supply : supplys) {
                List details = supply.getDetails();
                if (!CollectionUtils.isEmpty((Collection)details)) {
                    this.terminalSupplyDetailRepository.saveBatch(this.nebulaToolkitService.copyCollectionByBlankList((Iterable)details, TerminalSupplyDetailVo.class, TerminalSupplyDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
                }
                this.terminalSupplyRepository.save(this.nebulaToolkitService.copyObjectByBlankList((Object)supply, TerminalSupplyEntity.class, HashSet.class, ArrayList.class, new String[0]));
            }
        }
    }

    @Override
    public void createBatch(Set<TerminalSupplyEntity> terminalSupplyEntities) {
        if (!CollectionUtils.isEmpty(terminalSupplyEntities)) {
            for (TerminalSupplyEntity supply : terminalSupplyEntities) {
                List<TerminalSupplyDetailEntity> details = supply.getTerminalSupplyDetails();
                if (!CollectionUtils.isEmpty(details)) {
                    this.terminalSupplyDetailRepository.saveBatch(details);
                }
                this.terminalSupplyRepository.save((Object)supply);
            }
        }
    }
}

