/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalDto;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalVoServiceImpl
implements TerminalVoService {
    @Autowired
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired
    private ParticipatorTagVoService participatorTagVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<TerminalVo> findByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return null;
        }
        List<Terminal> terminals = this.terminalRepository.findByTerminalCodes(terminalCodes);
        if (CollectionUtils.isEmpty(terminals)) {
            return null;
        }
        List terminalVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[]{"contactPersons", "terminalSupplies", "participatorTags"});
        terminalVos.stream().forEach(terminalVo -> {
            Set participatorTags = terminalVo.getParticipatorTags();
            if (!CollectionUtils.isEmpty((Collection)participatorTags)) {
                String participatorTag = participatorTags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
                terminalVo.setTagDescription(participatorTag);
            }
        });
        return terminalVos;
    }

    public TerminalVo validate(TerminalVo terminal) {
        Validate.notNull((Object)terminal, (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u8425\u4e1a\u6267\u7167\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalAddress(), (String)"\u7ec8\u7aef\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalMdmPaginationDto terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        terminalMdmPaginationDto.setLicenseRegisterNumber(terminal.getRegistrationNumber());
        terminalMdmPaginationDto.setTerminalName(terminal.getTerminalName());
        terminalMdmPaginationDto.setTerminalAddress(terminal.getTerminalAddress());
        TerminalMdmVo terminalMdmVo = this.terminalMdmService.findDetailByRegisterOrName(terminalMdmPaginationDto);
        TerminalVo resultTerminal = new TerminalVo();
        if (terminalMdmVo == null) {
            resultTerminal.setResultType(Integer.valueOf(1));
            return resultTerminal;
        }
        Terminal cpsTerminal = this.terminalRepository.validate(terminal);
        if (cpsTerminal == null) {
            resultTerminal = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalMdmVo, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            resultTerminal.setLegalPersonSName(terminalMdmVo.getLicensePersonName());
            resultTerminal.setOrganization(terminalMdmVo.getOrgName());
            resultTerminal.setRegistrationNumber(terminalMdmVo.getLicenseRegisterNumber());
            resultTerminal.setCompanyName(terminalMdmVo.getLicenseFirmName());
            resultTerminal.setShopSignPath(terminalMdmVo.getShopImagePath());
            resultTerminal.setBusinessLicensePath(terminalMdmVo.getLicenseImagePath());
            resultTerminal.setResultType(Integer.valueOf(2));
        } else {
            resultTerminal.setResultType(Integer.valueOf(3));
        }
        return resultTerminal;
    }

    public List<String> findByExternalIdentifier(String dealerCode) {
        if (StringUtils.isBlank((CharSequence)dealerCode)) {
            return Lists.newArrayList();
        }
        return this.terminalRepository.findByExternalIdentifier(dealerCode);
    }

    public Set<TerminalVo> findByConditions(TerminalDto terminalDto) {
        Set<TerminalVo> terminalVoSet = this.terminalRepository.findVoByConditions(terminalDto);
        if (!CollectionUtils.isEmpty(terminalVoSet)) {
            List codeList = terminalVoSet.stream().map(TerminalVo::getTerminalCode).collect(Collectors.toList());
            Map<Object, Object> participatorTagMap = new HashMap();
            List participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
            if (!CollectionUtils.isEmpty((Collection)participatorTagList)) {
                participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
            }
            for (TerminalVo terminalVo : terminalVoSet) {
                List tags = (List)participatorTagMap.get(terminalVo.getTerminalCode());
                if (CollectionUtils.isEmpty((Collection)tags)) continue;
                String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
                terminalVo.setTagDescription(participatorTag);
            }
        }
        return terminalVoSet;
    }

    public Page<TerminalVo> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
        terminalPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        Page<Terminal> terminals = this.terminalRepository.findByConditions(pageable, terminalPaginationDto);
        if (!CollectionUtils.isEmpty((Collection)terminals.getRecords())) {
            List terminalVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)terminals.getRecords(), Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalVos.forEach(vo -> {
                if (!CollectionUtils.isEmpty((Collection)vo.getTerminalSupplies())) {
                    StringBuilder supplyDesc = new StringBuilder();
                    vo.getTerminalSupplies().forEach(supply -> {
                        if (!CollectionUtils.isEmpty((Collection)supply.getTerminalSupplyDetails())) {
                            for (TerminalSupplyDetailVo detailVo : supply.getTerminalSupplyDetails()) {
                                if (!ObjectUtils.isNotEmpty((Object)detailVo.getName())) continue;
                                supplyDesc.append(",").append(detailVo.getName());
                            }
                        }
                    });
                    if (ObjectUtils.isNotEmpty((Object)supplyDesc)) {
                        vo.setSupplyDescription(supplyDesc.substring(1).toString());
                    }
                }
            });
            Page page = new Page();
            page.setRecords(terminalVos);
            page.setTotal(page.getTotal());
            page.setCurrent(page.getCurrent());
            page.setSize(page.getSize());
            return page;
        }
        return null;
    }
}

