/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.notifier;

import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.entity.ParticipatorTag;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.local.repository.ParticipatorTagRepository;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.external.mdm.sdk.event.ParticipatorMdmTagEventListener;
import com.biz.crm.cps.external.mdm.sdk.vo.CustomerTagRefreshMdmVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ParticipatorMdmTagEventListenerImpl
implements ParticipatorMdmTagEventListener {
    private static final Logger log = LoggerFactory.getLogger(ParticipatorMdmTagEventListenerImpl.class);
    @Autowired
    private ParticipatorTagRepository participatorTagRepository;
    @Autowired
    private TerminalRepository terminalRepository;
    @Autowired
    private DealerRepository dealerRepository;

    @Transactional
    public void onRefresh(CustomerTagRefreshMdmVo refreshVo) {
        Validate.notNull((Object)refreshVo, (String)"\u7f3a\u5931\u64cd\u4f5c\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)refreshVo.getClientCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Terminal terminal = this.terminalRepository.findByTerminalCode(refreshVo.getClientCode());
        DealerEntity dealer = this.dealerRepository.findByCustomerCode(refreshVo.getClientCode());
        if (Objects.isNull((Object)terminal) && Objects.isNull((Object)dealer)) {
            log.info("\u672a\u53d1\u73b0\u6307\u5b9a\u6807\u7b7e\u5206\u5229\u5bf9\u8c61:{}", (Object)refreshVo.getClientCode());
            return;
        }
        this.participatorTagRepository.deleteByParticipatorCodes(Lists.newArrayList((Object[])new String[]{refreshVo.getClientCode()}));
        if (CollectionUtils.isEmpty((Collection)refreshVo.getTagList())) {
            return;
        }
        Set tags = refreshVo.getTagList().stream().map(customerTagMdmVo -> {
            ParticipatorTag participatorTag = new ParticipatorTag();
            participatorTag.setParticipatorCode(customerTagMdmVo.getClientCode());
            participatorTag.setTagDescription(customerTagMdmVo.getTagDescription());
            participatorTag.setTagType(customerTagMdmVo.getTagType());
            return participatorTag;
        }).collect(Collectors.toSet());
        this.participatorTagRepository.saveBatch(tags);
    }
}

