/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.notifier;

import com.biz.crm.cps.business.participator.local.entity.ContactPerson;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalSupplyDetailRepository;
import com.biz.crm.cps.business.participator.local.service.TerminalService;
import com.biz.crm.cps.business.participator.local.service.TerminalSupplyService;
import com.biz.crm.cps.external.mdm.sdk.event.TerminalMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalContactMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TerminalMdmEventListenerImpl
implements TerminalMdmEventListener {
    @Autowired
    TerminalService terminalService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TerminalSupplyService terminalSupplyService;
    @Autowired
    private TerminalSupplyDetailRepository terminalSupplyDetailRepository;

    public String onChange(TerminalMdmVo oldVo, TerminalMdmVo newVo) {
        Terminal terminal = this.convertModel(newVo);
        this.terminalService.update(terminal);
        this.terminalSupplyService.updateSupply(newVo);
        return null;
    }

    private Terminal convertModel(TerminalMdmVo terminalMdmVo) {
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalMdmVo, Terminal.class, HashSet.class, LinkedList.class, new String[0]));
        terminal.setOrganization(terminalMdmVo.getOrgName());
        terminal.setOrganizationCode(terminalMdmVo.getOrgCode());
        terminal.setCustomerOrganization(terminalMdmVo.getCustomerOrgName());
        terminal.setCustomerOrganizationCode(terminalMdmVo.getCustomerOrgCode());
        terminal.setChannel(terminalMdmVo.getChannel());
        terminal.setChannelName(terminalMdmVo.getChannelName());
        terminal.setShopSignPath(terminalMdmVo.getShopImagePath());
        terminal.setShopSignFilename(terminalMdmVo.getShopImagePath());
        terminal.setBusinessLicensePath(terminalMdmVo.getLicenseImagePath());
        terminal.setBusinessLicenseFilename(terminalMdmVo.getLicenseImagePath());
        terminal.setLegalPersonSName(terminalMdmVo.getLicensePersonName());
        terminal.setRegistrationNumber(terminalMdmVo.getLicenseRegisterNumber());
        terminal.setCompanyName(terminalMdmVo.getLicenseFirmName());
        terminal.setLocation(StringUtils.join((Object[])new String[]{terminalMdmVo.getLatitude(), ",", terminalMdmVo.getLongitude()}));
        List contacts = terminalMdmVo.getContacts();
        if (!CollectionUtils.isEmpty((Collection)contacts)) {
            HashSet contactPersonSet = Sets.newHashSet();
            for (TerminalContactMdmVo contact : contacts) {
                ContactPerson contactPerson = new ContactPerson();
                contactPerson.setContactPersonName(contact.getContactName());
                contactPerson.setContactPersonPhone(contact.getContactPhone());
                contactPersonSet.add(contactPerson);
            }
            terminal.setContactPersons(contactPersonSet);
        }
        return terminal;
    }

    public List<String> onFind() {
        return this.terminalService.findTerminalCode();
    }
}

