/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.state;

import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.local.service.state.TerminalStateAction;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalAuditStatusEnum;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AuditRejectTerminalState
implements TerminalStateAction {
    @Autowired
    TerminalRepository terminalRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pass(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u6570\u636e\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u7ec8\u7aef\u6570\u636e\u7f3a\u5931\u4e3b\u952e", (Object[])new Object[0]);
        this.terminalRepository.updateAuditStatusById(TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode(), terminal.getId());
    }

    @Override
    public void cancel(Terminal terminal) {
    }

    @Override
    public TerminalAuditStatusEnum stateEnum() {
        return TerminalAuditStatusEnum.AUDIT_REJECT;
    }
}

